/* =========================== START PROC NMKH ======================== */
PROC NMKH(XGRID,H,KORD,KSCALE) ;
    /*  THIS CALCULATES GAUSSIAN HIGHER ORDER KERNEL FUNCTIONS  */
    /*  THE BANDWIDTH H AND THE KERNEL ORDER MUST BE SCALARS  */
    /*  KSCALE IS A FINAL SCALE FACTOR, OFTEN TAKEN = 1/N  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL R,SLH,CS,ARG,NARG,HP,HPN,M,IS ;

  R = KORD / 2 ;
  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;

           /*  CALCULATE CROSS TERM IN BIAS  */
  ARG = XGRID' / H  ;
  NARG = NORM(ARG) ;
  HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
  HPN = ARG ;                         /*  1ST HERMITE POLY  */
  M = HP .* NARG ;
  IS = 1 ;
  DO WHILE IS <= (R - 1) ;
    HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
    HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
    M = M|(HP .* NARG) ;
    IS = IS + 1 ;
  ENDO ;
  M = CS' * M ;         /*  SUM ON S   */

  M = M / H ;
  M = M * KSCALE ;

  RETP(M') ;
ENDP ;
/* ============================ END PROC NMKH ======================== */
