/* =========================== START PROC NMLBIN ======================== */
PROC (1)=NMLBIN(DATA,LEFT,RIGHT,NXGRID) ;
    /*  THIS DOES LINEAR BINNING OF THE VECTOR DATA  */
    /*  LEFT AND RIGHT ARE THE FIRST AND LAST GRID CENTERS   */
    /*  NXGRID IS THE NUMBER OF BINS  */

 LOCAL INCX,CENTS,FLAG,WTS,BINCTS ;

 INCX = (RIGHT - LEFT) / (NXGRID - 1) ;
 CENTS = SEQA(LEFT,INCX,NXGRID) ;

 FLAG = -(DATA .<= LEFT) ;            /*  -1 AT SITES BELOW RANGE  */
 FLAG = FLAG + (DATA .>= RIGHT) ;     /*  +1 AT SITES ABOVE RANGE  */

 WTS = (DATA - LEFT) * (NXGRID - 1) / (RIGHT - LEFT) ;
                /*  TRANSFORM [LEFT,RIGHT] TO [0,NXGRID-1]
                        I.E. PUT "BIN CENTERS ON INTEGERS"  */
 WTS = WTS - FLOOR(WTS) ;     /*  DISTANCE TO NEXT LOWEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;   /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */

 BINCTS = COUNTWTS(DATA,CENTS,WTS) ;   /*  USE THIS DISTANCE AS WEIGHT
                                           FOR NEXT GREATEST BIN  */

 WTS = 1 - WTS ;              /*  DISTANCE TO NEXT GREATEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;   /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */
 BINCTS = BINCTS + REV(COUNTWTS(-DATA,REV(-CENTS),WTS)) ;

 BINCTS[1,1] = BINCTS[1,1] + SUMC(FLAG .< -.5) ;
 BINCTS[NXGRID,1] = BINCTS[NXGRID,1] + SUMC(FLAG .> .5) ;

 RETP(BINCTS) ;
ENDP ;
/* ============================ END PROC NMLBIN ======================== */
