/* =========================== START PROC NMLINT ======================== */
PROC NMLINT(NEWX,OLDX,OLDY,SORTFL) ;
    /*  THIS DOES A LINEAR INTERPOLATION,  */
    /*  OF AN ENTIRE VECTOR OF NEW X VALUES  */
    /*  GIVEN A FUNCTION DETERMINED BY OLD X AND Y VALUES  */
    /*  OLD X'S ASSUMED TO BE IN INCREASING ORDER  */
    /*  SORTFL = 1 MEANS THE NEW X'S NEED TO BE SORTED  */
    /*         = 0 ASSUMES THE NEW X'S ALREADY SORTED  */
    /*  VALUES OUTSIDE THE RANGE, GET THE ENDPOINT RETURNED  */

  LOCAL NOX,NNX,SNX,ORIGI,VCTS,LCT,RCT,IVCTS,ISNX,NEWY,STFLAG,
            XL,XR,YL,YR,WT,INTY ;

  NOX = ROWS(OLDX) ;
  NNX = ROWS(NEWX) ;
  STFLAG = 0 ;            /*  CONSTRUCTION OF NEWY NOT STARTED YET  */

            /*  CONSTRUCT "SORTED" NEW X'S  */
  IF SORTFL > 0 ;
    "        SORTING NEW X'S " ;
    SNX = NEWX~SEQA(1,1,NNX) ;
    SNX = SORTC(SNX,1) ;
    ORIGI = SNX[.,2] ;
    SNX = SNX[.,1] ;
  ELSE ;
    SNX = NEWX ;
  ENDIF ;

  VCTS = NMCTS(SNX,OLDX,1) ;
                 /*  VECTOR OF COUNTS, TO DETERMINE WHERE IN OLDX
                                 WILL INTERPOLATE   */
  LCT = VCTS[1,1] ;             /*  COUNTS AT LEFT END  */
  RCT = VCTS[(NOX+1),1] ;       /*  COUNTS AT RIGHT END  */
  IVCTS = VCTS[2:NOX,1] ;        /*  INTERIOR COUNTS  */


  IF LCT > 0 ;        /*  IF THERE ARE VALUES BELOW RIGHT END  */
    NEWY = (OLDY[1,1] *  ONES(LCT,1)) ;
    STFLAG = 1 ;       /*  INDICATES NEWY ALREADY STARTED  */
  ENDIF ;

  IF SUMC(IVCTS) > 0 ;              /*  IF THERE ARE ANY INTERIOR OBS'S  */
    ISNX = SNX[(LCT+1):(NNX-RCT),1] ;      /*  INTERIOR SORTED NEW X'S  */
    XL = NMSELIF(OLDX[1:(NOX-1),1],IVCTS) ;      /*  X'S AT LEFT END  */
    XR = NMSELIF(OLDX[2:NOX,1],IVCTS) ;          /*  X'S AT RIGHT END  */
    YL = NMSELIF(OLDY[1:(NOX-1),1],IVCTS) ;      /*  Y'S AT LEFT END  */
    YR = NMSELIF(OLDY[2:NOX,1],IVCTS) ;          /*  Y'S AT RIGHT END  */
    WT = (XR - ISNX) ./ (XR - XL) ;        /*  WEIGHT ON LEFT SIDE  */
    INTY = WT .* YL + (1-WT) .* YR ;       /*  NEWLY INTERPOLATED VALUES  */
    IF STFLAG < 1 ;
      NEWY = INTY ;
      STFLAG = 1 ;
    ELSE ;
      NEWY = NEWY|INTY ;
    ENDIF ;
  ENDIF ;

  IF RCT > 0 ;        /*  IF THERE ARE VALUES ABOVE LEFT END  */
    IF STFLAG < 1 ;
      NEWY = (OLDY[NOX,1] *  ONES(RCT,1)) ;
      STFLAG = 1 ;
    ELSE ;
      NEWY = NEWY|(OLDY[NOX,1] *  ONES(RCT,1)) ;
    ENDIF ;
  ENDIF ;


  IF SORTFL > 0 ;
    NEWY = NEWY~ORIGI ;
    NEWY = SORTC(NEWY,2) ;
    NEWY = NEWY[.,1] ;
  ENDIF ;

  RETP(NEWY) ;
ENDP ;
/* ============================ END PROC NMLINT ======================== */
