/* =========================== START PROC NMMCGBW ======================== */
PROC (1)=NMMCGBW(DIFWTS,A,B,HGRID,DEL,PILF,M,HOTFLAG,SD) ;
    /*  THIS CALCULATES VARIOUS VERSIONS   */
    /*  OF THE "MIN CRITERION" SELECTOR,  */
    /*  WHICH GENERALIZES BCV   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  DEL = 0 USES DIAGONALS OUT IN THE MAIN PART  */
    /*  PILF SAYS WHAT TYPE OF PILOT TO USE, 0 = N(0,SD) REFERENCE  */
    /*  -K = K-TIMES ESTIMATED, DIAGONALS OUT   */
    /*  +K = K-TIMES ESTIMATED, DIAGONALS IN   */
    /*  M  IS THE POWER OF H IN THE PILOT BANDWIDTH, G  */
    /*  M = 1  DOES NOT WORK WITH DEL = 1     */
    /*  HOTFLAG IS 1 FOR INCLUSION OF NEXT HIGHER ORDER TERM, 0 NOT  */
    /*  ALL CONSTANTS ARE SAME AS FOR NMSCGB  */

  LOCAL DIAGF,DERIV,KORD,NOBS,M2,M4,RK,RF,RFP,
      KK4,NI,PRF,PRFP,H,RLL,C0,C1,C2,CSIG,CMU1,CMU2,CMU3,
      C,P,GGRID,IH,H,GR2,V,B,MCV ;


  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;


  M2 = 1 ;
  M4 = 3 ;
  RK = 1 / (2* SQRT(PI)) ;
  KK4 = 3 / (8 * SQRT(PI)) ;

  NI = ABS(PILF) ;
  IF  PILF > 0 ;     /*  DIAGONALS IN PILOTS  */
    DIAGF = 1 ;
  ELSE ;     /*  DIAGONALS OUT PILOTS  */
    DIAGF = 0 ;
  ENDIF ;

  RFP = NMI2ABW(DIFWTS,A,B,NI,2,KORD,DIAGF,SD) ;
  C0 = (RK / (M2^2 * RFP))^(1/5) ;
  C1 = M2^2 / 4 ;
  C2 = M2 * M4 / 24 ;


  IF M /=  -2 ;
    IF DEL == 0 ;
      RF = NMI2ABW(DIFWTS,A,B,NI,0,KORD,DIAGF,SD) ;
      RFP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
      RLL = 105 * (64 - 9 * 16 * M + 99 * M^2) / (SQRT(2 * PI) * 2^15) ;
      CSIG = 2 * RF * M2^4 * RLL ;
      CMU1 = (1 + M / 2) * RFP * M2^2 * M2 ;
      P = (M/5) - (2/13) ;
      C = (9 * CSIG / (4 * CMU1^2))^(1/13) ;
      C = C / C0^M ;
    ELSE ;
      RFP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
      RLL = 3 * (4 - 5 * M) / (SQRT(PI) * 2^5) ;
      CMU1 = (1 + M / 2) * RFP * M2^2 * M2 ;
      CMU3 = M2^2 * RLL ;
      P = (M/5) - (1/7) ;
      C = (CMU3 / CMU1)^(1/7) ;
      C = C / C0^M ;
    ENDIF ;
  ELSE ;
    IF DEL == 0 ;
      RF = NMI2ABW(DIFWTS,A,B,NI,0,KORD,DIAGF,SD) ;
      RLL = 105 * (64 - 9 * 16 * M + 99 * M^2) / (SQRT(2 * PI) * 2^15) ;
      CSIG = 2 * RF * M2^4 * RLL ;
      RFP = NMI2ABW(DIFWTS,A,B,NI,4,KORD,DIAGF,SD) ;
      CMU2 = - RFP * M2^2 * (M4 + 3 * M2^2) / 12 ;
      P = -44/85 ;
      C = (9 * CSIG / ((8 * CMU2)^2))^(1/17) ;
      C = (9 * CSIG / (8 * CMU2^2))^(1/17) ;
      C = C * C0^2 ;
    ELSE ;
      RFP = NMI2ABW(DIFWTS,A,B,NI,4,KORD,DIAGF,SD) ;
      CMU2 = - RFP * M2^2 * (M4 + 3 * M2^2) / 12 ;
      RLL = 3 * (4 - 5 * M) / (SQRT(PI) * 2^5) ;
      CMU3 = M2^2 * RLL ;
      P = -23/45 ;
      C = (-CMU3 / CMU2)^(1/9) ;
      C = C * C0^2 ;
    ENDIF ;
  ENDIF ;

  GGRID = (C * NOBS^P) * HGRID^M ;

  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    GR2 = GGRID[IH,1] * SQRT(2) ;
    V = RK / (NOBS * H) ;
    B = H^4 * C1 * NMI2HBW(DIFWTS,A,B,GR2,2,KORD,DEL) ;
                                   /*  R(F'')  */
    IF HOTFLAG == 1 ;
      B = B - H^6 * C2 * NMI2HBW(DIFWTS,A,B,GR2,3,KORD,DEL) ;
                                        /*  R(F''')  */
    ENDIF ;
    IF IH == 1 ;
      MCV = (V + B);
    ELSE ;
      MCV = MCV|(V + B) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(MCV) ;
ENDP;
/* ======================== END PROCEDURE NMMCGBW ======================== */
