/* =========================== START PROC NMMCT ======================== */
PROC NMMCT(V) ;
    /*  THIS COUNTS THE NUMBER OF MODES IN THE COLUMN VECTOR V  */
    /*  A MODE HERE IS AN ENTRY WHICH IS >= THE ENTRY ON BOTH SIDES  */
    /*  WHEN THERE ARE SEVERAL SUCH POINTS NEXT TO EACH OTHER  */
    /*  (HENCE HAVING THE SAME VALUE) ONLY ONE MODE IS COUNTED  */
    /*  MODES AT ENDPOINTS ARE NOT COUNTED  */
    /*  RETURN IS NUMBER OF SUCH MODES  */

  LOCAL NV,DV,UP,DN,FLAT,DNCHNG,UPCHNG,CHNG,NMAX,BEGFLAT,ENDFLAT,FLATIND,I ;

  NV = ROWS(V) ;

  DV = V[2:NV,1] - V[1:(NV-1),1] ;   /* GIVES "SLOPES" BETWEEN GRID POINTS */
  UP = (DV .> 0.0) ;                   /* FLAGS UPWARD SLOPES */
  DN = (DV .< 0.0) ;                   /* FLAGS DOWNWARD SLOPES */
  FLAT = ONES((NV-1),1) - UP - DN ;    /* FLAGS FLAT SPOTS */

  UPCHNG = UP[2:(NV-1),1] - UP[1:(NV-2),1] ;
                 /*  FLAGS CHANGES IN SLOPES, -1 FOR UP TO (0 OR DOWN)
                       1 FOR (0 OR DOWN) TO UP, 0 OTHERWISE  */
  DNCHNG = DN[1:(NV-2),1] - DN[2:(NV-1),1] ;
                 /*  FLAGS CHANGES IN SLOPES, -1 FOR (0 OR UP) TO DOWN
                       1 FOR (0 OR DOWN) TO UP, 0 OTHERWISE  */
  CHNG = UPCHNG .* (UPCHNG .== DNCHNG) ;
                 /*  FLAGS CHANGES IN SLOPES, -1 FOR UP TO DOWN
                       1 FOR DOWN TO UP, 0 OTHERWISE  */

  NMAX = SUMC(CHNG .== -1) ;  /*  COUNTS NUMBER OF TIMES FROM UP TO DOWN  */


  IF (SUMC(FLAT) > 0) ;     /*  IF THERE ARE ANY FLAT PLACES  */

    BEGFLAT = FLAT .* ((0|FLAT[1:(NV-2)]) .== 0) ;
                   /*  FLAGS LOCATIONS AT BEGINNING OF FLAT PARTS  */
    ENDFLAT = FLAT .* ((FLAT[2:(NV-1)]|0) .== 0) ;
                   /*  FLAGS LOCATIONS AT ENDING OF FLAT PARTS  */

    FLATIND = SELIF(SEQA(1,1,(NV-1)),BEGFLAT) ;
                           /*  VECTOR OF INDICES OF BEGFLATS  */
    FLATIND = FLATIND~SELIF(SEQA(1,1,(NV-1)),ENDFLAT) ;
                           /*  MATRIX OF PAIRED INDICES OF FLATS  */

             /*  COUNT ONE WHEN FLAT IS A MAXFLAT  */
    I = 1 ;
    DO WHILE I <= ROWS(FLATIND) ;

      IF (FLATIND[I,1] .== 1) ;
              /*  I.E. FLAT STARTS AT LEFT END  */

            IF (FLATIND[I,2] == (NV-1)) ;
                    /*  I.E. FLAT QUITS AT RIGHT END  */

                         NMAX = NMAX + 1 ;

            ELSE ;
              IF (DN[(FLATIND[I,2]+1),1] == 1) ;
                    /*  I.E. SLOPE SUCCEEDING ENDFLAT IS DN  */

                         NMAX = NMAX + 1 ;

              ENDIF ;
            ENDIF ;

      ELSE ;
        IF (UP[(FLATIND[I,1]-1),1] == 1) ;
              /*  I.E. SLOPE PRECEEDING BEGFLAT IS UP  */

            IF (FLATIND[I,2] == (NV-1)) ;
                    /*  I.E. FLAT QUITS AT RIGHT END  */

                         NMAX = NMAX + 1 ;

            ELSE ;
              IF (DN[(FLATIND[I,2]+1),1] == 1) ;
                    /*  I.E. SLOPE SUCCEEDING ENDFLAT IS DN  */

                         NMAX = NMAX + 1 ;

              ENDIF ;
            ENDIF ;

        ENDIF ;

      ENDIF ;

      I = I + 1 ;
    ENDO ;

  ENDIF ;

  RETP(NMAX) ;
ENDP ;
/* ============================ END PROC NMMCT ======================== */
