/* =========================== START PROC NMMCV ======================== */
PROC NMMCV(DATA,HGRID) ;
   /*  DIRECT MATRIX CALCULATION OF STUTE'S MODIFIED CROSS-VALIDATION  */
   /*  DATA ARE A COLUMN VECTOR OF X'S  */
   /*  CAUTION: THIS USES n BY n MATRICES,              */
   /*          SO CAN EASILY FILL WORKSPACE FOR n TOO LARGE  */
   /*  ASSUMES THE STANDARD NORMAL KERNEL  */
   /*  OUTPUT IS A VECTOR OF VALUES OF MCV       */

 LOCAL N,NH,IK2,D,R2,VMCV,IH,H,MDIF,MCV,KMDIF ;

 N = ROWS(DATA) ;
 NH = ROWS(HGRID) ;

 IK2 = 1 / (2 * SQRT(PI)) ;     /*  INTEGRAL OF K SQUARED  */
 D = 1 / 2 ;                    /*  (1/2) INTEGRAL OF X^2 K  */
 R2 = SQRT(2) ;

 VMCV = ZEROS(NH,1) ;
 IH = 1 ;
 DO WHILE IH <= NH ;
   "WORKING ON H NUMBER" IH ;
       /*  CAUTION: THIS SCREEN WRITE CAN SLOW DOWN PROGRAMS,
               BE CAREFUL ABOUT INCLUDING THIS KIND OF THING  */
   H = HGRID[IH] ;

   MDIF = DATA - DATA' ;          /*  MATRIX OF DIFFERENCES  */
   MDIF = MDIF / H ;

   MCV = PDFN(MDIF / R2) / R2 ;    /*  CONVOLUTION OF GAUSSIAN KERNELS  */
   KMDIF = PDFN(MDIF) ;            /*  GAUSSIAN KERNEL  */
   MCV = MCV - KMDIF ;
   MCV = MCV - D * ((MDIF .* MDIF - 1) .* KMDIF) ;
                                    /*  SECOND DERIVATIVE OF GAUSSIAN  */

   MCV = DIAGRV(MCV,ZEROS(N,1)) ;    /*  REMOVE DIAGONAL  */
   MCV = SUMC(SUMC(MCV)) ;      /*  DOUBLE SUMMATION  */
   MCV = IK2 / (N * H)  +  MCV / (N * (N-1) * H) ;

   VMCV[IH] = MCV ;

   IH = IH + 1 ;
 ENDO ;


 RETP(VMCV) ;
ENDP ;
/* ============================ END PROC NMMCV ======================== */
