/* =========================== START PROC NMMINR ======================== */
PROC (1)=NMMINR(X,Y,FLAG) ;
    /*  THIS CALCULATES MINIMIZERS  */
    /*  X AND Y ARE ARGUMENTS AND CORRESPONDING VALUES OF A   */
    /*  FUNCTION TO BE MINIMIZED  */
    /*  THE X'S ARE ASSUMED TO BE ORDERED  */
    /*  WHEN FLAG = 0, GLOBAL MINIMIZER IS FOUND  */
    /*  WHEN FLAG < 0 (>0), SMALLEST (LARGEST) LOCAL MINIMIZER IS FOUND   */
    /*  RETURNED VALUE IS A VECTOR CONTAINING  (1) THE MINIMIZING VALUE,   */
    /*  (2) -1,0,1,5 TO INDICATE IF ENDPOINTS ARE HIT   */
    /*      OR A STRANGE QUADRATIC FIT WAS ENCOUNTERED,   */
    /*  (3) THE NUMBER OF LOCAL MINIMA   */

  LOCAL NX,YMAX2,DIFS,POSFLAG,NEGFLAG,MINFLAG,NMIN,IMIN,XX,YY,MX,COEFF,XMIN ;

  NX = ROWS(X) ;

                /*  FIND INDEX OF IMPORTANT LOCAL MIN  */
  YMAX2 = 2 * MAXC(ABS(Y)) ;
  DIFS = (Y|YMAX2) - (YMAX2|Y) ;
  POSFLAG = (DIFS .>= 0) ;    /*  FLAG WHERE DIFS ARE POSITIVE  */
  NEGFLAG = (DIFS .<= 0) ;    /*  FLAG WHERE DIFS ARE NEGATIVE  */
  MINFLAG = (1|NEGFLAG) .* (POSFLAG|1) ;    /*  FLAGS LOCAL MINIMA   */
  NMIN = SUMC(MINFLAG) ;               /*  NUMBER OF LOCAL MINIMA  */
  IF FLAG < 0 ;
    IMIN = MAXINDC(MINFLAG) - 1  ;  /*  INDEX OF FIRST MIN  */
  ELSEIF FLAG > 0 ;
    IMIN = NX + 2 - MAXINDC(REV(MINFLAG))  ;  /*  INDEX OF LAST MIN  */
  ELSE ;
    IMIN = MININDC(Y) ;    /*  INDEX OF OVERALL MINIMIZER  */
  ENDIF ;

                /*  CHECK FOR ENDPOINTS  */
  IF IMIN <= 1 ;
     "  LEFT END WAS HIT" ;
     RETP(X[1,1]|-1|NMIN) ;  /*  MINRP, ENDPT FLAG, NUMBER OF MINS  */
  ELSEIF IMIN >= NX ;
     "  RIGHT END WAS HIT" ;
     RETP(X[NX,1]|1|NMIN) ;  /*  MINRP, ENDPT FLAG, NUMBER OF MINS  */
  ELSE ;

            /*  FIT A PARABOLA TO THE ABOVE SELECTED VALUES  */
     XX = X[(IMIN-1):(IMIN+1),1] ;
     YY = Y[(IMIN-1):(IMIN+1),1] ;
     MX = (XX.*XX)~XX~ONES(3,1) ;
     COEFF = INV(MX) * YY ;
     XMIN = -COEFF[2,1] / (2 * COEFF[1,1]) ;
     IF XMIN <= XX[3,1] AND XMIN >= XX[1,1] ;
        RETP(XMIN|0|NMIN) ;
     ELSE ;
        RETP(XX[2,1]|5|NMIN) ;
     ENDIF;
  ENDIF ;
ENDP ;
/* ============================ END PROC NMMINR ======================== */
