/* =========================== START PROC NMMISE ======================== */
PROC NMMISE(N,HGRID,MU,SIG2,W,KORD) ;
    /*  THIS CALCULATES MISE USING NORMAL KERNEL OF ORDER KORD  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  KORD = 2,4,6...  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL R,I,J,IK2,CS,IH,H,SLL,SLLH,SLLHH,ARG,NARG,
          HP,HPN,M,IS,S4,CROSS,IF2,VAR,B2 ;

  R = KORD / 2 ;

           /*  CALCULATE INT(K^2)  */
  I = SEQA(0,1,R) ;
  J = I' ;
  IK2 = ((2 * I) + (2 * J))! ;
  IK2 = IK2 ./ EXP((3 * (I + J) + 1) .* LN(2)) ;
  IK2 = IK2 ./ ((I + J)!) ;
  IK2 = IK2 ./ (I!) ;
  IK2 = IK2 ./ (J!) ;
  IK2 = SUMC(SUMC(IK2)) / SQRT(PI) ;

  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;

  IH = 1 ;
  FORMAT /RD 4,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    IF IH/10 == FLOOR(IH/10) ; "WORKING ON H NUMBER " IH ; ENDIF ;
    H = HGRID[IH,1] ;

            /*  USEFUL MATRICES  */
    SLL = SQRT(SIG2' + SIG2) ;
    SLLH = SQRT(H^2 + SIG2' + SIG2) ;
    SLLHH = SQRT(2*H^2 + SIG2' + SIG2) ;

             /*  CALCULATE INNER DOUBLE SUM   */
    ARG = (MU' - MU) ./ SLLHH ;
    NARG = NORM(ARG) ;
    HP = ONES(ROWS(MU),ROWS(MU)) ;       /*  0TH HERMITE POLY  */
    HPN = ARG ;                         /*  1ST HERMITE POLY  */
    M = W' * (HP .* NARG ./ SLLHH) * W ;
    IS = 1 ;
    DO WHILE IS <= (2 * R - 2) ;
      HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
      HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
      M = M~(W' * (HP .* NARG .* H^(2*IS) ./ SLLHH^(2*IS + 1)) * W) ;
                              /*  DOUBLE SUM ON L,L'  */
      IS = IS + 1 ;
    ENDO ;

             /*  CALCULATE OUTER DOUBLE SUM   */
    M = M .* ONES(R,1) ;
    M = ROTATER(M,SEQA(0,-1,R)) ;
    M = M[.,1:R] ;
    S4 = CS' * M * CS ;

             /*  CALCULATE CROSS TERM IN BIAS  */
    ARG = (MU' - MU) ./ SLLH ;
    NARG = NORM(ARG) ;
    HP = ONES(ROWS(MU),ROWS(MU)) ;       /*  0TH HERMITE POLY  */
    HPN = ARG ;                         /*  1ST HERMITE POLY  */
    M = W' * (HP .* NARG ./ SLLH) * W ;
    IS = 1 ;
    DO WHILE IS <= (R - 1) ;
      HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
      HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
      M = M|(W' * (HP .* NARG .* H^(2*IS) ./ SLLH^(2 * IS + 1)) * W) ;
                              /*  DOUBLE SUM ON L,L'  */
      IS = IS + 1 ;
    ENDO ;
    CROSS = CS' * M ;         /*  SUM ON S   */

             /*  CALCULATE INT(F^2) TERM IN BIAS  */
    ARG = (MU' - MU) ./ SLL ;
    NARG = NORM(ARG) ;
    IF2 = W' * (NARG ./ SLL) * W ;

    IF IH == 1 ;
      VAR = (IK2 / H  -  S4) ./ N ;
      B2 = S4 - 2 * CROSS + IF2 ;
    ELSE ;
      VAR = VAR|((IK2 / H  -  S4) ./ N) ;
      B2 = B2|(S4 - 2 * CROSS + IF2) ;
    ENDIF ;
    IH = IH + 1 ;
  ENDO ;

  RETP((VAR+B2)~VAR~B2) ;
ENDP ;
/* ============================ END PROC NMMISE ======================== */
