/* =========================== START PROC NMMISEM ======================== */
PROC NMMISEM(N,MU,SIG2,W,KORD,HFACTOR,NHGRID,HACC,NHSTEP) ;
    /*  THIS CALCULATES THE MINIMIZER OF MISE  */
    /*  USING NORMAL KERNEL OF ORDER KORD  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  KORD = 2,4,6...  */
    /*  INITIAL GRIDSEARCH IS DONE ON [h_AMISE/HFACTOR, h_AMISE*HFACTOR]  */
    /*                  HFACTOR <= 1 SKIPS GRIDSEARCH  */
    /*  NHGRID IS NUMBER OF GRIDPOINTS FOR SEARCH  */
    /*                  NHGRID <= 1 SKIPS GRIDSEARCH  */
    /*  HACC IS ACCURACY FOR NEWTON'S METHOD IMPROVEMENT  */
    /*  NHSTEP IS MAXIMUM NUMBER OF STEPS FOR NEWTON'S METHOD IMPROVEMENT  */
    /*  REQUIRES NORM.PRC
                 NMAMISEM.G
                 NMMISE.G
                 NMDMISE.G  ALREADY LOADED  */
  LOCAL HAMISE,SHGRID,EHGRID,INCH,HGRID,MISE,HO,I,OMISE,HN,DMISE,DDMISE ;

  "CALCULATING h_AMISE" ;
  HAMISE = NMAMISEM(N,MU,SIG2,W,KORD) ;
  HAMISE = HAMISE[1,1] ;

  IF (HFACTOR > 1 AND NHGRID > 1) ;
    "DOING INITIAL GRIDSEARCH" ;
    SHGRID = HAMISE / HFACTOR ;
    EHGRID = HAMISE * HFACTOR ;
    INCH = (EHGRID/SHGRID)^(1/(NHGRID - 1)) ;
    HGRID = SEQM(SHGRID,INCH,NHGRID) ;
    "CALCULATING MISE" ;
    MISE = NMMISE(N,HGRID,MU,SIG2,W,KORD) ;
    MISE = MISE[.,1] ;
    HO = HGRID[MININDC(MISE),1] ;
  ELSE ;
    HO = HAMISE ;
  ENDIF ;

  "DO NEWTON'S METHOD IMPROVEMENT" ;
  I = 0 ;
  MISE = NMDMISE(N,HO,MU,SIG2,W,KORD) ;
  DDMISE = MISE[1,3] ;
  DMISE = MISE[1,2] ;
  OMISE = MISE[1,1] ;
  FORMAT 10,6 ;
  " STEP " I ", H = " HO ", MISE = " OMISE ;

  DO WHILE I <= NHSTEP ;
    I = I + 1 ;

               /*  UPDATE  */
    HN = HO - DMISE / DDMISE ;
    MISE = NMDMISE(N,HN,MU,SIG2,W,KORD) ;
    DDMISE = MISE[1,3] ;
    DMISE = MISE[1,2] ;
    MISE = MISE[1,1] ;

                /*  MAKE SURE HN IS NOT WORSE  */
    DO WHILE (MISE > OMISE) OR (HN < 0) ;
      "          READJUSTED BECAUSE MISE GOT WORSE, OR H < 0    " ;
      HN = (HO + HN) / 2 ;
      MISE = NMDMISE(N,HN,MU,SIG2,W,KORD) ;
      DDMISE = MISE[1,3] ;
      DMISE = MISE[1,2] ;
      MISE = MISE[1,1] ;
    ENDO ;

    FORMAT 10,6 ;
    " STEP " I ", H = " HN ", MISE = " MISE ;

            /*  ACCURATE ENOUGH?  */
    IF ABS(HN - HO) <= HACC ;
      BREAK ;             /*  JUMP OUT OF LOOP  */
    ENDIF ;

    HO = HN ;
    OMISE = MISE ;

  ENDO ;

  RETP(HN|MISE) ;
ENDP ;
/* ============================ END PROC NMMISEM ======================== */
