/* =========================== START PROC NMNIGEN ======================== */
PROC NMNIGEN(MU,SIG2,W) ;
    /*  THIS GENERATES GRID POINTS AND WEIGHTS FOR   */
    /*  NUMERICAL INTEGRATION OF INTEGRALS OF FUNCTIONS  */
    /*  OF THE NORMAL MIXTURE DENSITIES   */
    /*  SHOULD BE QUITE ACCURATE UP TO DERIVATIVE 6  */
    /*  ACCURACY CALCULATION WAS DONE IN NMNUNI1.PRG  */
    /*  OUTPUT IS A MATRIX WITH:  */
    /*    FIRST  COL = XGRID      */
    /*          (CAUTION: NOT EQUALLY SPACED, AND MAY HAVE  */
    /*                      SOME DUPLICATIONS (BUT < 10%))  */
    /*    SECOND COL = WEIGHTS FOR A TRAPEZOIDAL APPROX    */

  LOCAL NXGI,RAD,I,L,R,DEL,XGRID,NXG,WTS ;

  NXGI = 400 ;
       /*  NUMBER OF GRID POINTS PER PIECE  */
       /*  RAISED FROM SUGGESTION OF 100, FROM NMNUMI1.PRG  */
       /*  TO GIVE 6 DIGIT ACCURACY FOR THESE EXAMPLES  */
  RAD = 10 ;
       /*  NUMBER OF SD'S TO GO UP AND DOWN, FROM NMNUMI1.PRG  */

            /*  GENERATE RAW VERSION OF XGRID  */
  I = 1 ;
  DO WHILE I <= ROWS(MU) ;

    L = MU[I] - RAD * SQRT(SIG2[I]) ;
    R = MU[I] + RAD * SQRT(SIG2[I]) ;
    DEL = (R - L) / (NXGI - 1) ;

    IF I == 1 ;
      XGRID = SEQA(L,DEL,NXGI) ;
    ELSE ;
      XGRID = XGRID|SEQA(L,DEL,NXGI) ;
    ENDIF ;

    I = I + 1 ;
  ENDO ;

  XGRID = SORTC(XGRID,1) ;

  NXG = ROWS(XGRID) ;

       /*  GENERATE WEIGHTS FOR SIMPLE TRAPEZOID NUMERICAL INTEGRATION  */
  WTS = XGRID[3:NXG] - XGRID[1:(NXG-2)] ;
  WTS = (XGRID[2] - XGRID[1])|WTS|(XGRID[NXG]-XGRID[NXG-1]) ;
  WTS = WTS / 2 ;


  RETP(XGRID~WTS) ;
ENDP ;
/* ============================ END PROC NMNIGEN ======================== */
