/* =========================== START PROC NMPCHK ======================== */
PROC NMPCHK(MU,SIG2,W) ;
    /*  THIS CHECKS THAT INPUTS FORM VALID PARAMTERS FOR A NORMAL MIXTURE  */
    /*  RETURNS:  1 - SIG2 HAS WRONG NUMBER OF ROWS
                  2 - W HAS WRONG NUMBER OF ROWS
                  3 - SIG2 HAS WRONG NUMBER OF ROWS
                  4 - W HAS WRONG NUMBER OF ROWS
                  5 - IF SIG2 NOT ALL POSITIVE
                  6 - IF W NOT ALL NONEGATIVE
                  7 - IF W'S DO NOT SUM TO ONE  */
  LOCAL K,NDIST ;

  K = ROWS(MU) ;
  NDIST = COLS(MU) ;

              /*  CHECK LENGTHS ARE SAME   */
  IF ROWS(SIG2) /= K ; RETP(1) ; ENDIF ;
  IF ROWS(W) /= K ; RETP(2) ; ENDIF ;

              /*  CHECK SAME NUMBER OF COLUMNS  */
  IF COLS(SIG2) /= NDIST ; RETP(3) ; ENDIF ;
  IF COLS(W) /= NDIST ; RETP(4) ; ENDIF ;

              /*  CHECK SIG2  */
  IF SUMC(SUMC(SIG2 .<= 0)) > 0 ; RETP(4) ; ENDIF ;

              /*  CHECK W  */
  IF SUMC(SUMC(W .< 0)) > 0 ; RETP(6) ; ENDIF ;
  IF SUMC( (SUMC(W) ./= 1) ) > 0 ; RETP(7) ; ENDIF ;

  RETP(0) ;
ENDP ;
/* ============================ END PROC NMPCHK ======================== */
