/* =========================== START PROC NMPCVB ========================= */
PROC (1)=NMPCVB(DATA,NBINS,A,B,HGRID,M) ;
    /*  THIS CALCULATES PARTITIONED CROSS-VALIDATION   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  IT DOES BINNING INSIDE, USING NMLBIN  */
    /*  THEN USES REPEATEDLY NMCVB  */
    /*  DATA ARE ASSUMED TO BE IN RANDOM unsorted ORDER */
    /*  M IS THE NUMBER OF SUBSETS INTO WHICH DATA ARE PARTITIONED  */
    /*  HGRID IS APPROPRIATELY ADJUSTED IN TERMS OF M, SO THAT   */
    /*  MINIMIZER APPEARS ON FULL DATA SIZE SCALE  */

  LOCAL PHGRID,APCV,NOBS,NR,MDATA,NDUP,I,VDATA,BINCTS,PCV ;

            /*  SCALE UP H'S TO SUBSAMPLE RANGE  */
  PHGRID = HGRID * M^(1/5) ;

            /*  INITIALIZE VECTOR OF AVERAGES  */
  APCV = ZEROS(ROWS(HGRID),1) ;

            /*  RESHAPE DATA  */
  NOBS = ROWS(DATA) ;
  NR = CEIL(NOBS / M) ;      /*  ENOUGH ROWS TO INCLUDE EVERYTHING  */
  MDATA = RESHAPE(DATA,NR,M) ;
  NDUP = (NR * M) - NOBS ;   /*  NUMBER OF OBS'S DUPLICATED AT END  */

  I = 1 ;
  DO WHILE I <= M ;
    "WORKING ON SUBSET " I "      OF " M ;

    VDATA = MDATA[.,I] ;
    IF I > (M - NDUP) ;     /*  NEED TO KICK OUT DUPLICATED OBS AT END  */
      VDATA = VDATA[1:(NR-1),1] ;
    ENDIF ;

    BINCTS = NMLBIN(VDATA,A,B,NBINS) ;
    PCV = NMCVB(BINCTS,A,B,PHGRID) ;
    APCV = APCV + PCV ;

    I = I + 1 ;
  ENDO ;

  APCV = APCV / M ;

 RETP(APCV) ;
ENDP;
/* ====================== END PROCEDURE NMPCVB =========================== */
