/* =========================== START PROC NMPFIT ======================== */
PROC NMPFIT(DATA,AMAX,RELACC) ;
    /*  DATA IS ASSUMED TO BE A COLUMN VECTOR OF OBSERVATIONS  */
    /*  THIS DOES A MAXIMUM LIKELIHOOD FIT OF A PARABOLIC  */
    /*  DENSITY, SUPPORTED BETWEEN THE SMALLEST AND BIGGEST OBS'S,  */
    /*  AND CENTERED IN THE MIDDLE OF THE SUPPORT  */
    /*  TO THE DATA, USING AN ITERATIVE IMPROVEMENT METHOD   */
    /*  AMAX IS THE LARGEST ALLOWABLE COEFFICIENT IN THE SQUARE PART  */
    /*  RELACC IS THE RELATIVE ACCURACY OF THE RESULTING EST OF  */
    /*  THE COEFFICIENT OF THE PARABOLA  */
    /*  RETURNS COEFFICIENT AND INTERCEPT  */
  LOCAL XMIN,XMAX,S,ANEW,B,Y,AYMAX,Y2MT,Y2MT2,MBD,DL,ERR,AOLD,DLP,EF ;

  XMIN = MINC(DATA) ;
  XMAX = MAXC(DATA) ;

  S = (XMAX - XMIN) / 2 ;

  IF S == 0 ;
    ANEW = 0 ;
    B = 0 ;
  ELSE ;
    Y = (DATA - XMIN) / S - 1 ;  /*  TRANSFORM TO [-1,1] FOR SIMPLICITY  */
    AYMAX = AMAX * S^3 ;
    AYMAX = MINC(AYMAX|(3/2)) ;
    Y2MT = Y^2 - (1/3) ;      /*  USEFUL VECTORS  */
    Y2MT2 = Y2MT^2 ;

    MBD = SUMC(Y2MT2) ;

    IF MBD <= 10^(-25) ;       /*  PROBLEM VERY POORLY CONDITIONED  */
      ANEW = AYMAX ;
      B = 0 ;
    ELSEIF (AYMAX < -3/4)  ;   /*  ALLOWED INTERVAL EMPTY  */
      ANEW = AYMAX ;
      B = 0 ;
    ELSE ;                     /*  OK TO PROCEED WITH ITERATIONS  */
      MBD = 4 * MBD / 9 ;

      ANEW = ((-3/4) + AYMAX) / 2 ;   /*  START IN CENTER OF ALLOWED RANGE */

      DL = SUMC(Y2MT ./ (ANEW * Y2MT + 1/2)) ;  /*  EVALUATE FUNCTION  */
      ERR = ABS(DL) / (MINC(ABS(ANEW)|RELACC) * MBD) ;

      FORMAT /RD 12,8 ;
      "A = " ANEW  "    REL ERROR = " ERR ;

      DO WHILE ERR > RELACC ;
        AOLD = ANEW ;

        DLP = - SUMC(Y2MT2 ./ (AOLD * Y2MT + 1/2)^2) ; /* EVALUATE DERIV */

        ANEW = AOLD - (DL / DLP) ;    /*  NEWTON'S IMROVEMENT  */

        IF (ANEW <= -3/4) ;       /*  BELOW LEFT END  */
          ANEW = (AOLD + 9 * (-3/4)) / 10 ;    /*  GO 9/10 WAY TO END  */
          EF = -1 ;
        ELSEIF (ANEW >= AYMAX) ;       /*  ABOVE RIGHT END  */
          ANEW = (AOLD + 9 * AYMAX) / 10 ;    /*  GO 9/10 WAY TO END  */
          EF = 1 ;
        ELSE ;
          EF = 0 ;
        ENDIF ;

        DL = SUMC(Y2MT ./ (ANEW * Y2MT + 1/2)) ; /*  EVALUATE FUNCTION  */

        IF EF < -.5 ;    /*  WENT BEYOND LEFT END  */
          ERR = ABS(ANEW - 3/4) / MAXC(ABS(ANEW)|RELACC) ;
                                                    /* DIST TO LEFT END */
        ELSEIF EF > .5 ;    /*  WENT BEYOND RIGHT END  */
          ERR = ABS(ANEW - AYMAX) / MAXC(ABS(ANEW)|RELACC) ;
                                                   /* DIST TO RIGHT END */
        ELSE ;    /*  REGULAR STEP  */
          ERR = MINC(ERR|(ABS(DL) / (MINC(ABS(ANEW)|RELACC) * MBD))) ;
                                                   /* ACCURACY OF ROOT  */
        ENDIF ;

        "A = " ANEW  "    REL ERROR = " ERR ;
      ENDO ;

      B = 1/2 - ANEW / 3 ;

    ENDIF ;

    ANEW = ANEW / S^3 ;     /*  BACK TRANSFORM, FROM [-1,1]  */
    B = B / S ;

  ENDIF ;

  RETP(ANEW|B) ;
ENDP ;
/* ============================ END PROC NMPFIT ======================== */
