/* =========================== START PROC NMSATG ========================= */
PROC (1)=NMSATG(BINCTS,A,B,HGRID,PARAM) ;
    /*  THIS CALCULATES A BINNED VERISON OF  */
    /*  SILVERMAN'S AUTOMATIC TEST GRAPH BANDWIDTH SELECTOR   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  PARAM IS A TUNING PARAMETER, THAT SHOULD BE BETWEEN 1.5 AND 3.5  */
    /*  SUGGESTED VALUE IS 2.5  */

  LOCAL NXGRID,IH,H,DDFH,DIFS,V,C ;

  NXGRID = ROWS(BINCTS) ;

  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;

    DDFH = NMDFHB(BINCTS,A,B,H,2) ;        /*  SECOND DERIVATIVE ESTIMATE  */
    DIFS = DDFH[2:NXGRID,1] - DDFH[1:(NXGRID-1),1] ;
    V = SUMC(ABS(DIFS)) ;                  /*  TOTAL VARIATION OF FHAT''  */

    IF IH == 1 ;
      C = LN(V) + PARAM * LN(H) ;
    ELSE ;
      C = C|(LN(V) + PARAM * LN(H)) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(C) ;
ENDP;
/* ======================== END PROCEDURE NMSATG ========================= */
