/* =========================== START PROC NMSBBW ======================== */
PROC (1)=NMSBBW(DIFWTS,A,B,HGRID,M,SD,FLAG) ;
    /*  THIS CALCULATES VARIOUS DOUBLE SMOOTHED BANDWDITH SELECTORS   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  USING ESTIMATED VALUES IN G, JONES SHEATHER DIAGONALS IN VERSION  */
    /*  M  IS THE POWER OF H IN THE PILOT BANDWIDTH  */
    /*  NOTE M = 1 NOT ALLOWED HERE   */
    /*  FLAG = 0 GIVES G = H,  1 GIVES ORDINARY SCV,   */
    /*    2 GIVES DIAGONALS-IN ESTIMATED VERSION   */

  LOCAL DIAGF,DERIV,KORD,NOBS,M2,M4,RK,KK4,PRF,PRFP,H,RF,RFPP,RFPPP,RFPPPP,
         D1,D2,D3,FACTOR,D,A1,B1,C1,C2,GGRID,IH,H,G,V,H1,H2,H3,DS,
         TERM1,TERM2,TERM3 ;

  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  M2 = 1 ;      /*  GAUSSIAN  K  AND  L  */
  M4 = 3 ;
  RK = 1 / (2* SQRT(PI)) ;
  KK4 = 3 / (8 * SQRT(PI)) ;

  IF FLAG == 0 ;
    DIAGF = 0 ;   /*  DIAGONALS OUT VERSION   */
    GGRID = HGRID ;
  ELSEIF FLAG == 1 ;
    DIAGF = 1 ;   /*  DIAGONALS IN VERSION   */

    M2 = 1 ;      /*  GAUSSIAN  K  AND  L  */
    M4 = 3 ;
    RK = 1 / (2* SQRT(PI)) ;
    RF = RK ;       /*  STANDARD NORMAL REFERENCE DISTRIBUTION  */
    RFPP = 3 / (8 * SQRT(PI)) ;
    RFPPP = 15 / (16 * SQRT(PI)) ;
    RFPPPP = 105 / (32 * SQRT(PI)) ;
    D1 = 105 * SQRT(2/PI) / 2^10 ;
    D2 = - D1 / 2 ;
    D3 = D1 * 19 / 4 ;
    FACTOR = 1 - 5 * M / 4 ;
    D = FACTOR^2 * D1 - (M/2) * FACTOR * D2  + (M/4)^2 * D3 ;

    IF M == -2 ;
      C1 = 81 * 4 * D * RK^(34/5) ;
      C1 = C1 / ( M2^(68/5) * (M4 + 3 * M2^2)^2 )  ;
      C1 = C1^(1/17) ;
      C2 = ( RF / (RFPPPP^2 * RFPP^(34/5)) )^(1/17) ;
      GGRID = C1 * C2 * SD^3 * NOBS^(-44/85) * HGRID^(-2) ;
    ELSE ;
      A1 = ((1 + M/2) * M2 * RFPPP) / (5 * RFPP) ;
      B1 = SQRT(2 * RF * D / (25 * RFPP^2)) ;
      C1 = (3 * B1 / (2 * A1))^(2/13) ;
      C2 = (M2^2 * RFPP / RK)^(M/5) ;
      GGRID = C1 * C2 * SD^(1-M) * NOBS^(M/5 - 2/13) * HGRID^M ;
    ENDIF ;

  ELSEIF FLAG == 2 ;
    DIAGF = 1 ;   /*  DIAGONALS IN VERSION   */

    PRF = RK / SD ;
    H = NMI2HH(NOBS,0,KORD,PRF,PRF,DIAGF) ;
    RF = NMI2HBW(DIFWTS,A,B,H,0,KORD,DIAGF) ;

    IF M == -2 ;
      PRFP = KK4 / SD^5 ;
      H = NMI2HH(NOBS,2,KORD,PRF,PRFP,DIAGF) ;
      RFPP = NMI2HBW(DIFWTS,A,B,H,2,KORD,DIAGF) ;

      PRFP = (105 / (32 * SQRT(PI)) ) / SD^9 ;
      H = NMI2HH(NOBS,4,KORD,PRF,PRFP,DIAGF) ;
      RFPPPP = NMI2HBW(DIFWTS,A,B,H,4,KORD,DIAGF) ;

      C1 = 42 * KK4 * RK^(18/5) ;
      C1 = C1 / ( (M4 + 3 * M2^2) * M2^(36/5) )  ;
      C1 = C1^(1/9) ;
      C2 = RFPPPP^(-1/9) * RFPP^(-2/5) ;
      GGRID = C1 * C2 * NOBS^(-23/45) * HGRID^(-2) ;
    ELSE ;
      PRFP = (15 / (16 * SQRT(PI)) ) / SD^7 ;
      H = NMI2HH(NOBS,3,KORD,PRF,PRFP,DIAGF) ;
      RFPPP = NMI2HBW(DIFWTS,A,B,H,3,KORD,DIAGF) ;

      C1 = (4 - 5 * M) / (4 + 2 * M)  ;
      C1 = (C1 * KK4 / M2^2)^(1/7) ;
      C2 = (1 / RFPPP)^(1/7) ;
      GGRID = C1 * C2 * NOBS^(-1/7) ;
      GGRID = GGRID .* ONES(ROWS(HGRID),1) ;
    ENDIF ;
  ENDIF ;


  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    G = GGRID[IH,1] ;

    V = RK / (NOBS * H) ;
    H1 = SQRT(2 * G^2 + 2 * H^2) ;
    H2 = SQRT(2 * G^2 + H^2) ;
    H3 = G * SQRT(2) ;
    TERM1 = NMI2HBW(DIFWTS,A,B,H1,DERIV,KORD,DIAGF) ;
    TERM2 = NMI2HBW(DIFWTS,A,B,H2,DERIV,KORD,DIAGF) ;
    TERM3 = NMI2HBW(DIFWTS,A,B,H3,DERIV,KORD,DIAGF) ;
    V = V - (TERM1 / NOBS) ;
    IF IH == 1 ;
      DS = (V + TERM1 - 2 * TERM2 + TERM3) ;
    ELSE ;
      DS = DS|(V + TERM1 - 2 * TERM2 + TERM3) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(DS) ;
ENDP;
/* ======================== END PROCEDURE NMSBBW ======================== */
