/* =========================== START PROC NMSCGBW ======================== */
PROC (1)=NMSCGBW(DIFWTS,A,B,HGRID,DEL,PILF,BF,M,SD) ;
    /*  THIS CALCULATES VARIOUS SCV VERSIONS   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  DEL = 0 USES DIAGONALS OUT IN THE MAIN PART  */
    /*  PILF SAYS WHAT TYPE OF PILOT TO USE, 0 = N(0,SD) REFERENCE  */
    /*  -K = K-TIMES ESTIMATED, DIAGONALS OUT   */
    /*  +K = K-TIMES ESTIMATED, DIAGONALS IN   */
    /*  BF = 0 FOR ORIGINAL SCV  */
    /*       1 FOR ORDINARY BOOTSTRAP VERSION   */
    /*       2 FOR CLEVER BOOTSTRAP VERSION   */
    /*            (THEN IMPLICITLY USE M = -2, DEL = 0)   */
    /*  M  IS THE POWER OF H IN THE PILOT BANDWIDTH, G  */
    /*  M = 1  DOES NOT WORK WITH DEL = 1     */

  LOCAL DIAGF,DERIV,KORD,NOBS,M2,M4,RK,RF,RFP,
      KK4,NI,PRF,PRFP,H,RLL,C0,CSIG,CMU1,CMU2,CMU3,
      C,P,GGRID1,GGRID2,IH,H,G1,G2,V,H1,H2,H3,SCV,
      TERM1,TERM2,TERM3,VTERM ;


  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;


  M2 = 1 ;
  M4 = 3 ;
  RK = 1 / (2* SQRT(PI)) ;
  KK4 = 3 / (8 * SQRT(PI)) ;

  NI = ABS(PILF) ;
  IF  PILF > 0 ;     /*  DIAGONALS IN PILOTS  */
    DIAGF = 1 ;
  ELSE ;     /*  DIAGONALS OUT PILOTS  */
    DIAGF = 0 ;
  ENDIF ;

  RFP = NMI2ABW(DIFWTS,A,B,NI,2,KORD,DIAGF,SD) ;
  C0 = (RK / (M2^2 * RFP))^(1/5) ;

  IF  BF < 1.5 ;    /*  NOT USING SMOOTHED BOOTSTRAP WITH DIFFERENT g'S  */
    IF M /=  -2 ;
      IF DEL == 0 ;
        RF = NMI2ABW(DIFWTS,A,B,NI,0,KORD,DIAGF,SD) ;
        RFP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
        RLL = 105 * (64 - 9 * 16 * M + 99 * M^2) / (SQRT(2 * PI) * 2^15) ;
        CSIG = 2 * RF * M2^4 * RLL ;
        CMU1 = (1 + M / 2) * RFP * M2^2 * M2 ;
        P = (M/5) - (2/13) ;
        C = (9 * CSIG / (4 * CMU1^2))^(1/13) ;
        C = C / C0^M ;
      ELSE ;
        RFP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
        RLL = 3 * (4 - 5 * M) / (SQRT(PI) * 2^5) ;
        CMU1 = (1 + M / 2) * RFP * M2^2 * M2 ;
        CMU3 = M2^2 * RLL ;
        P = (M/5) - (1/7) ;
        C = (CMU3 / CMU1)^(1/7) ;
        C = C / C0^M ;
      ENDIF ;
    ELSE ;
      IF DEL == 0 ;
        RF = NMI2ABW(DIFWTS,A,B,NI,0,KORD,DIAGF,SD) ;
        RLL = 105 * (64 - 9 * 16 * M + 99 * M^2) / (SQRT(2 * PI) * 2^15) ;
        CSIG = 2 * RF * M2^4 * RLL ;
        RFP = NMI2ABW(DIFWTS,A,B,NI,4,KORD,DIAGF,SD) ;
        CMU2 = - RFP * M2^2 * (M4 + 3 * M2^2) / 12 ;
        P = -44/85 ;
        C = (9 * CSIG / ((8 * CMU2)^2))^(1/17) ;
        C = (9 * CSIG / (8 * CMU2^2))^(1/17) ;
        C = C * C0^2 ;
      ELSE ;
        RFP = NMI2ABW(DIFWTS,A,B,NI,4,KORD,DIAGF,SD) ;
        CMU2 = - RFP * M2^2 * (M4 + 3 * M2^2) / 12 ;
        RLL = 3 * (4 - 5 * M) / (SQRT(PI) * 2^5) ;
        CMU3 = M2^2 * RLL ;
        P = -23/45 ;
        C = (-CMU3 / CMU2)^(1/9) ;
        C = C * C0^2 ;
      ENDIF ;
    ENDIF ;

    GGRID1 = (C * NOBS^P) * HGRID^M ;
    GGRID2 = GGRID1 ;
  ELSE ;
    RF = NMI2ABW(DIFWTS,A,B,NI,1,KORD,DIAGF,SD) ;
    RFP = NMI2ABW(DIFWTS,A,B,NI,4,KORD,DIAGF,SD) ;
    C = 24 * (2*M2) * RF ;
    C = C / (RFP * M2^2 * (4*M4) * C0^4) ;

    GGRID1 = (C^(1/2) * C0^2 * NOBS^(-1/2)) * HGRID^(-2) ;
    GGRID2 = (C^(1/2) * C0^(-1) * NOBS^(1/10)) * HGRID ;
  ENDIF ;

  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    G1 = GGRID1[IH,1] ;
    G2 = GGRID2[IH,1] ;
    V = RK / (NOBS * H) ;
    H1 = SQRT(2 * G1^2 + 2 * H^2) ;
    H2 = SQRT(2 * G1^2 + H^2) ;
    H3 = G1 * SQRT(2) ;
    TERM1 = NMI2HBW(DIFWTS,A,B,H1,DERIV,KORD,DEL) ;
    TERM2 = NMI2HBW(DIFWTS,A,B,H2,DERIV,KORD,DEL) ;
    TERM3 = NMI2HBW(DIFWTS,A,B,H3,DERIV,KORD,DEL) ;
    IF  BF > .5 ;   /*  DOING SMOOTHED BOOTSTRAP VERSION  */
      IF  BF > 1.5 ;    /*  SMOOTHED BOOTSTRAP WITH DIFFERENT g'S  */
        H1 = SQRT(2 * G2^2 + 2 * H^2) ;
        VTERM = NMI2HBW(DIFWTS,A,B,H1,DERIV,KORD,DEL) ;
      ELSE ;
        VTERM = TERM1 ;
      ENDIF ;
      V = V - (VTERM / NOBS) ;
    ENDIF ;
    IF IH == 1 ;
      SCV = (V + TERM1 - 2 * TERM2 + TERM3) ;
    ELSE ;
      SCV = SCV|(V + TERM1 - 2 * TERM2 + TERM3) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(SCV) ;
ENDP;
/* ======================== END PROCEDURE NMSCGBW ======================== */
