/* =========================== START PROC NMSCKG ======================== */
PROC NMSCKG(DATA,FRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE MEDIAN K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  FRAC IS THE FRACTION OF THE NUMBER OF OBSERVATIONS  */
    /*  TO INCLUDE IN THE SPACING  */

  LOCAL SC,NOBS,K,CENTER,RADIUS,TKGAP ;

              /*  GET K - GAP  */
  SC = NMKGAP(DATA,FRAC) ;

  NOBS = ROWS(DATA) ;
  K = ROUND(FRAC * NOBS) ;

               /*  GET THEORETICAL KGAP FOR N(0,1)  */
  CENTER = (NOBS + ROUND(FRAC * NOBS) + 2) / (4 * (NOBS + 1)) ;
  RADIUS = (ROUND(FRAC * NOBS) + 1) / (2 * (NOBS + 1)) ;
  TKGAP = PHIINV(CENTER + RADIUS) - PHIINV(CENTER - RADIUS) ;

  SC = SC / TKGAP ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */

  RETP(SC) ;
ENDP ;
/* ============================ END PROC NMSCKG ======================== */
