/* =========================== START PROC NMSCKGS ======================== */
PROC NMSCKGS(DATA,IN,IFRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE MEDIAN K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  USES SIMULATED TRUE VALUES, SO ONLY VALUES SUPPORTED ARE:  */
    /*  IN = 1,2  CORRESPONDING TO N = 100, 1000  */
    /*  IFRAC = 1,2,3,4  CORRESPONDING TO FRAC = 1/4,1/8,1/16,1/N  */
    /*  REQUIRES FILE NMKGAPS.FMT IN CURRENT DIRECTORY  */

  LOCAL NOBS,FRAC,SC,K,EKGAP ;

  IF IN == 1 ;
    NOBS = 100 ;
  ELSEIF IN == 2 ;
    NOBS = 1000 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;

  IF IFRAC == 1 ;
    FRAC = 1/4 ;
  ELSEIF IFRAC == 2 ;
    FRAC = 1/8 ;
  ELSEIF IFRAC == 3 ;
    FRAC = 1/16 ;
  ELSEIF IFRAC == 4 ;
    FRAC = 1/NOBS ;
  ELSE ;
    RETP(0) ;
  ENDIF ;

              /*  GET K - GAP  */
  SC = NMKGAP(DATA,FRAC) ;

  K = ROUND(FRAC * NOBS) ;

               /*  GET EXPECTED N(0,1) KGAP  */
  LOAD EKGAP = NMKGAPS ;
  EKGAP = EKGAP[IN,IFRAC] ;
  SC = SC / EKGAP ;     /*  ADJUST SO EST. 1 FOR N(0,1)  */

  RETP(SC) ;
ENDP ;
/* ============================ END PROC NMSCKGS ======================== */
