/* =========================== START PROC NMSCPF ======================== */
PROC NMSCPF(DATA,FRAC,SD) ;
    /*  THIS GIVES A BANDWIDTH FOR DENSITY ESTIMATION  */
    /*  USING A STANDARD NORMAL KERNEL FUNCTION  */
    /*  BASED ON A PARABOLA FIT TO THE DATA WITHIN  */
    /*  THE SMALLEST FRAC-GAP OF THE DATA, THEN EXTENDED  */
    /*  TO THE REST OF THE RANGE BY A SIMPLE N^(-1/5) RULE */
    /*  SD IS AN AUXILIARY SCALE EST USED TO AVOID OVERSMOOTHING  */
    /*  BY REPLACING THE DERIVED BANDWIDTH WITH  */
    /*  ITS MINIMUM WITH THE NORMAL REFERENCE  */

  LOCAL NOBS,K,V,KG,IMKG,AMAX,RELACC,A,RFPP,RNPP,RK,H ;

  NOBS = ROWS(DATA) ;
  K = ROUND(FRAC * NOBS) ;      /* NUMBER OF OBS'S CORRESPONDING TO FRAC  */

  V = SORTC(DATA,1) ;
  KG = V[(K+1):NOBS,1] - V[1:(NOBS-K),1] ;    /*  VECTOR OF KGAPS  */

  IMKG = MININDC(KG) ;       /*  INDEX AT BEGINNING OF SMALLEST KGAP  */

  V = V[IMKG:(IMKG+K),1] ;       /*  OBS'S INSIDE SMALLEST KGAP  */

  AMAX = 0 ;
  RELACC = .0001 ;
  A = NMPFIT(V,AMAX,RELACC) ;    /*  FIT RESTRICTED SYMMETRIC PARABOLA  */
  A = A[1,1] ;                      /*  COEFFICIENT OF SQUARE PART  */

  RFPP = (V[K+1,1] - V[1,1]) * (2 * A)^2 ;   /*  PARABOLA FIT ESTIMATE  */
  RFPP = RFPP / FRAC ;

  RNPP = 3 / (8 * SQRT(PI) * SD^5) ;      /*  N(0,SD^2) REFERENCE  */

  RFPP = MAXC(RFPP|RNPP) ;        /*  GUARD AGAINST FUNNY RFPP'S  */

  RK = 1 / (2 * SQRT(PI)) ;
  H = (RK / (NOBS * RFPP))^(1/5) ;

  RETP(H) ;
ENDP ;
/* ============================ END PROC NMSCPF ======================== */
