/* =========================== START PROC NMSCROT ======================== */
PROC NMSCROT(NOBS,SD,IQR,IOPT) ;
    /*  THIS GIVES SILVERMAN'S RULE OF THUMB BANDWIDTH  */
    /*  BASED ON SD AND IQR, DIRECTLY FROM HIS BOOK  */
    /*  ASSUMES A GAUSSIAN KERNEL  */
    /*    FOR IOPT = 1, USES EQUATION 3.28 + 3.30 ADJUSTMENT   */
    /*    FOR IOPT = 2, USES EQUATION 3.31   */

  LOCAL A,H ;

  A = MINC(SD|(IQR/1.34)) ;

  IF IOPT == 1 ;
    H = 1.06 * A * NOBS^(-1/5) ;
  ELSEIF IOPT == 2 ;
    H = .9 * A * NOBS^(-1/5) ;
  ENDIF ;

  RETP(H) ;
ENDP ;
/* ============================ END PROC NMSCROT ======================== */
