/* =========================== START PROC NMSCSS1 ======================== */
PROC NMSCSS1(DATA,IN) ;
    /*  THIS GIVES NORMALIZED VERSION OF SUPER SCLAE ESTIMATE 1  */
    /*  BASED ON THE MINIMUM OF THE MEDIAN 1 - SPACING  */
    /*  AND THE SMALLEST N/4 GAP  */
    /*  USES SIMULATED TRUE VALUES, SO ONLY VALUES SUPPORTED ARE:  */
    /*  IN = 1,2  CORRESPONDING TO N = 100, 1000  */
    /*  REQUIRES FILES NMKGAPS.FMT AND NMSKGPS.FMT IN CURRENT DIRECTORY  */

  LOCAL NOBS,IFRAC,SC1,SC2,SC ;

  IF IN == 1 ;
    NOBS = 100 ;
  ELSEIF IN == 2 ;
    NOBS = 1000 ;
  ELSE ;
    RETP(0) ;
  ENDIF ;

              /*  GET NORMALIZED MEDIAN 1-SPACING  */
  IFRAC = 4 ;
  SC1 = NMSCKGS(DATA,IN,IFRAC) ;

              /*  GET NORMALIZED SMALLEST N/2 GAP */
  IFRAC = 1 ;
  SC2 = NMSCSKG(DATA,IN,IFRAC) ;

               /*  TAKE MIN  */
  SC = MINC(SC1|SC2) ;
  IF IN == 1 ;
    SC = SC / 0.9410642414081488 ;
  ELSEIF IN == 2 ;
    SC = SC / 0.9787166173268660 ;
  ENDIF ;

  RETP(SC) ;
ENDP ;
/* ============================ END PROC NMSCSS1 ======================== */
