/* =========================== START PROC NMSCVBW ======================== */
PROC (1)=NMSCVBW(DIFWTS,A,B,HGRID,M,SD) ;
    /*  THIS CALCULATES VARIOUS DOUBLE SMOOTHED BANDWDITH SELECTORS   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  M  IS THE POWER OF H IN THE PILOT BANDWIDTH  */

  LOCAL DERIV,KORD,NOBS,M2,M4,RK,RF,RFPP,RFPPP,RFPPPP,D1,D2,D3,FACTOR,D,
         C1,C2,G,A1,B1,IH,H,V,H1,H2,H3,DS,TERM1,TERM2,TERM3 ;

  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  M2 = 1 ;      /*  GAUSSIAN  K  AND  L  */
  M4 = 3 ;
  RK = 1 / (2* SQRT(PI)) ;
  RF = RK ;       /*  STANDARD NORMAL REFERENCE DISTRIBUTION  */
  RFPP = 3 / (8 * SQRT(PI)) ;
  RFPPP = 15 / (16 * SQRT(PI)) ;
  RFPPPP = 105 / (32 * SQRT(PI)) ;
  D1 = 105 * SQRT(2/PI) / 2^10 ;
  D2 = - D1 / 2 ;
  D3 = D1 * 19 / 4 ;
  FACTOR = 1 - 5 * M / 4 ;
  D = FACTOR^2 * D1 - (M/2) * FACTOR * D2  + (M/4)^2 * D3 ;


  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;

    IF M == -2 ;
      C1 = 81 * 4 * D * RK^(34/5) ;
      C1 = C1 / ( M2^(68/5) * (M4 + 3 * M2^2)^2 )  ;
      C1 = C1^(1/17) ;
      C2 = ( RF / (RFPPPP^2 * RFPP^(34/5)) )^(1/17) ;
      G = C1 * C2 * SD^3 * NOBS^(-44/85) * H^(-2) ;
    ELSE ;
      A1 = ((1 + M/2) * M2 * RFPPP) / (5 * RFPP) ;
      B1 = SQRT(2 * RF * D / (25 * RFPP^2)) ;
      C1 = (3 * B1 / (2 * A1))^(2/13) ;
      C2 = (M2^2 * RFPP / RK)^(M/5) ;
      G = C1 * C2 * SD^(1-M) * NOBS^(M/5 - 2/13) * H^M ;
    ENDIF ;

    V = RK / (NOBS * H) ;
    H1 = SQRT(2 * G^2 + 2 * H^2) ;
    H2 = SQRT(2 * G^2 + H^2) ;
    H3 = G * SQRT(2) ;
    TERM1 = NMI2HBW(DIFWTS,A,B,H1,DERIV,KORD,0) ;  /* EXCLUDE DIAGONALS */
    TERM2 = NMI2HBW(DIFWTS,A,B,H2,DERIV,KORD,0) ;  /* EXCLUDE DIAGONALS */
    TERM3 = NMI2HBW(DIFWTS,A,B,H3,DERIV,KORD,0) ;  /* EXCLUDE DIAGONALS */
    IF IH == 1 ;
      DS = (V + TERM1 - 2 * TERM2 + TERM3) ;
    ELSE ;
      DS = DS|(V + TERM1 - 2 * TERM2 + TERM3) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(DS) ;
ENDP;
/* ======================== END PROCEDURE NMSCVBW ======================== */
