/* =========================== START PROC NMSDB ======================== */
PROC (1)=NMSDB(BINCTS,A,B) ;
      /*  CALCULATES SAMPLE STANDARD DEVIATION FROM BINNED DATA   */
 LOCAL NBIN,NOBS,INC,BCENTS,AVG,SIG ;
 NBIN = ROWS(BINCTS) ;
 NOBS = SUMC(BINCTS) ;

 INC = (B - A) / (NBIN - 1) ;
 BCENTS = SEQA(A,INC,NBIN) ;
 AVG = (BINCTS' * BCENTS) / NOBS ;
 SIG = BCENTS - AVG ;
 SIG = SIG .* SIG ;        /*   (X_I - AVG)**2  */
 SIG = BINCTS' * SIG ;         /*   SUM((X_I - AVG)**2)  */
 SIG = SQRT(SIG / (NOBS - 1)) ;

 RETP(SIG) ;
ENDP ;
/* ============================ END PROC NMSDB ======================== */
