/* =========================== START PROC NMSEGBW ======================== */
PROC (1)=NMSEGBW(DIFWTS,A,B,HGRID,DEL,PILF,M,SD) ;
    /*  THIS CALCULATES VARIOUS SCV VERSIONS   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  DEL = 0 USES DIAGONALS OUT IN THE MAIN PART  */
    /*  PILF SAYS WHAT TYPE OF PILOT TO USE, 0 = N(0,SD) REFERENCE  */
    /*  -K = K-TIMES ESTIMATED, DIAGONALS OUT   */
    /*  +K = K-TIMES ESTIMATED, DIAGONALS IN   */
    /*  M  IS THE POWER OF H IN THE PILOT BANDWIDTH, A  */
    /*  PARK-MARRON IS DEL = 0, PILF = 0, M = 10/13  */
    /*  SHEATHER-JONES IS DEL = 1, PILF = 1, M = 5/7  */

  LOCAL DERIV,KORD,NOBS,M2,RK,NI,DIAGF,RK4,RF,RFPP,RFPPP,C,P,
      C,P,K40,AGRID,IH,H,AH,TERM,PIEQN ;


  DERIV = 2 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  M2 = 1 ;
  RK = 1 / (2 * SQRT(PI)) ;

  NI = ABS(PILF) ;
  IF  PILF > 0 ;     /*  DIAGONALS IN PILOTS  */
    DIAGF = 1 ;
  ELSE ;     /*  DIAGONALS OUT PILOTS  */
    DIAGF = 0 ;
  ENDIF ;


  IF DEL == 0 ;
    RK4 = 105 / (32 * SQRT(PI)) ;
    RF = NMI2ABW(DIFWTS,A,B,NI,0,KORD,DIAGF,SD) ;
    RFPP = NMI2ABW(DIFWTS,A,B,NI,2,KORD,DIAGF,SD) ;
    RFPPP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
    C = ((18 * RF * RK4) / (RFPPP^2))^(1/13) ;
    C = C * (RFPP / RK)^(M/5) ;
    C = C * M2^(-2/13+2*M/5) ;
    P = -2/13 + M/5 ;
  ELSE ;
    K40 = 3 / (SQRT(2 * PI)) ;
    RFPP = NMI2ABW(DIFWTS,A,B,NI,2,KORD,DIAGF,SD) ;
    RFPPP = NMI2ABW(DIFWTS,A,B,NI,3,KORD,DIAGF,SD) ;
    C = ((2 * K40) / RFPPP)^(1/7) ;
    C = C * (RFPP / RK)^(M/5) ;
    C = C * M2^(-1/7+2*M/5) ;
    P = -1/7 + M/5 ;
  ENDIF ;

  AGRID = (C * NOBS^P) * HGRID^M ;

  IH = 1 ;
  FORMAT 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    AH = AGRID[IH,1] ;
    TERM = NMI2HBW(DIFWTS,A,B,AH,DERIV,KORD,DEL) ;
    TERM = ( RK / (M2^2 * TERM * NOBS) )^(1/5) ;
    IF IH == 1 ;
      PIEQN = H - TERM ;
    ELSE ;
      PIEQN = PIEQN|(H - TERM) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;


  RETP(PIEQN) ;
ENDP;
/* ======================== END PROCEDURE NMSEGBW ======================== */
