/* =========================== START PROC NMSELIF ======================== */
PROC NMSELIF(M,CTS) ;
    /*  A MODIFICATION OF THE USUAL SELIF  */
    /*  CONSTRUCT A MATRIX WHOSE ROWS CONSIST OF ROWS OF M  */
    /*  REPEATED THE NUMBER OF TIMES IN CTS(j)  */
    /*  SO THE FIRST ROW IS REPEATED CTS(1) TIMES, ETC.  */

  LOCAL RM,CM,MCT,MM,I,OUT ;


  RM = ROWS(M) ;               /*  ROWS IN M AT START  */
  CM = COLS(M) ;               /*  COLUMNS IN M  */
  MCT = MAXC(CTS) ;            /*  MAX NUMBER OF REPEATS OF A ROW  */

  MM = SEQA(1,1,RM)~M ;        /*  ADD ROWINDICES FOR SORTING LATER  */

  I = 1 ;
  DO WHILE I <= MCT ;

    IF I == 1 ;
      OUT = SELIF(MM,(CTS .> (I - .5))) ;
    ELSE ;
      OUT = OUT|SELIF(MM,(CTS .> (I - .5))) ;
    ENDIF ;

    I = I + 1 ;
  ENDO ;

  OUT = SORTC(OUT,1) ;         /*  SORT TO PUT BACK INTO ORDER  */
  OUT = OUT[.,2:(CM+1)] ;      /*  PEEL OFF INDICES  */

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC NMSELIF ======================== */
