/* =========================== START PROC NMSKSCA ======================== */
PROC NMSKSCA(MU,SIG2,W,ENDPTS,NBIN) ;
    /*  FOR THE SCALED (ABRAMSON) KERNEL ESTIMATOR,                     */
    /*  THIS EVALUATES THE COEFF THAT DEPENDS ON X, I.E.  1/f(x)^(1/2), */
    /*  FOR THE ASY BEST SCALE, FOR THE GIVEN NORMAL MIXTURE DENSITY,   */
    /*  ON AN EQUALLY SPACED GRID OF NBIN POINTS,                       */
    /*  WITH ENDPTS GIVEN (AS A COLUMN VECTOR, LEFT|RIGHT)              */
    /*  REQUIRES NORM.PRC ALREADY LOADED                                */
  LOCAL INCX,XGRID,A ;

  INCX = (ENDPTS[2,1] - ENDPTS[1,1]) / (NBIN - 1) ;
  XGRID = SEQA(ENDPTS[1,1],INCX,NBIN) ;

  A = NMF(XGRID,MU,SIG2,W) ;      /*  NORMAL MIXTURE DENSITY  */

  IF A /= 0 ;      /*  CHECK ALL ELEMENTS NONZERO  */
    A = 1 ./ SQRT(A) ;
  ELSE ;           /*  CANNOT DO THIS   */
    "!!!!!     CANNOT CALCULATE A HERE, RETURNING 0     !!!!!" ;
    A = 0 ;
  ENDIF ;

  RETP(A) ;
ENDP ;
/* ============================ END PROC NMSKSCA ======================== */
