/* =========================== START PROC NMSKSHB ======================== */
PROC NMSKSHB(MU,SIG2,W,ENDPTS,NBIN) ;
    /*  FOR THE SHIFTED KERNEL ESTIMATOR,                             */
    /*  THIS EVALUATES THE COEFF THAT DEPENDS ON X, I.E.  f'(x)/f(x), */
    /*  FOR THE ASY BEST SHIFT, FOR THE GIVEN NORMAL MIXTURE DENSITY, */
    /*  ON AN EQUALLY SPACED GRID OF NBIN POINTS,                     */
    /*  WITH ENDPTS GIVEN (AS A COLUMN VECTOR, LEFT|RIGHT)            */
    /*  REQUIRES NORM.PRC ALREADY LOADED                              */
  LOCAL INCX,XGRID,DENOM,B ;

  INCX = (ENDPTS[2,1] - ENDPTS[1,1]) / (NBIN - 1) ;
  XGRID = SEQA(ENDPTS[1,1],INCX,NBIN) ;

  DENOM = NMF(XGRID,MU,SIG2,W) ;      /*  NORMAL MIXTURE DENSITY  */

  IF DENOM /= 0 ;      /*  CHECK ALL ELEMENTS NONZERO  */
    B = NMDF(XGRID,MU,SIG2,W,1) ;    /*  FIRST DERIVATIVE OF NORMAL MIX  */
    B = B ./ DENOM ;
  ELSE ;               /*  CANNOT DO THIS   */
    "!!!!!     CANNOT CALCULATE B HERE, RETURNING 0     !!!!!" ;
    B = 0 ;
  ENDIF ;

  RETP(B) ;
ENDP ;
/* ============================ END PROC NMSKSHB ======================== */
