/* =========================== START PROC NMTAY ======================== */
PROC NMTAY(DATA,HGRID) ;
   /*  DIRECT MATRIX CALCULATION OF TAYLOR'S SMOOTH BOOTSTRAP  */
   /*  DATA ARE A COLUMN VECTOR OF X'S  */
   /*  CAUTION: THIS USES n BY n MATRICES,              */
   /*          SO CAN EASILY FILL WORKSPACE FOR n TOO LARGE  */
   /*  ASSUMES THE STANDARD NORMAL KERNEL  */
   /*  OUTPUT IS A VECTOR OF VALUES OF TAY       */

 LOCAL N,NH,IK2,R2,R3,VTAY,IH,H,MDIF,DDIF,TAY,TERM2 ;

 N = ROWS(DATA) ;
 NH = ROWS(HGRID) ;

 IK2 = 1 / (2 * SQRT(PI)) ;     /*  INTEGRAL OF K SQUARED  */
 R2 = SQRT(2) ;
 R3 = SQRT(3) ;

 VTAY = ZEROS(NH,1) ;
 IH = 1 ;
 DO WHILE IH <= NH ;
   "WORKING ON H NUMBER" IH ;
       /*  CAUTION: THIS SCREEN WRITE CAN SLOW DOWN PROGRAMS,
               BE CAREFUL ABOUT INCLUDING THIS KIND OF THING  */
   H = HGRID[IH] ;

   MDIF = DATA - DATA' ;          /*  MATRIX OF DIFFERENCES  */
   MDIF = MDIF / H ;

   TAY = PDFN(MDIF / 2) / 2 ;
   TAY = TAY - 2 * PDFN(MDIF / R3) / R3 ;
   TAY = TAY + PDFN(MDIF / R2) / R2 ;

   TAY = DIAGRV(TAY,ZEROS(N,1)) ;    /*  REMOVE DIAGONAL  */
   TAY = SUMC(SUMC(TAY)) ;      /*  DOUBLE SUMMATION  */
   TAY = TAY / (N * N * H) ;

   TAY = IK2 / (N * H) + TAY ;

   VTAY[IH] = TAY ;

   IH = IH + 1 ;
 ENDO ;


 RETP(VTAY) ;
ENDP ;
/* ============================ END PROC NMTAY ======================== */
