/* =========================== START PROC NMTAYBW ======================== */
PROC (1)=NMTAYBW(DIFWTS,A,B,HGRID,DEL,BF,SD) ;
    /*  THIS CALCULATES TAYLOR'S VERSION OF SCV   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  DEL = 0 USES DIAGONALS OUT IN THE MAIN PART (DONE BY TAYLOR)  */
    /*  BF = 1 GIVES BOOTSTRAP VERSION, (TAYLOR USED 0)  */

  LOCAL DERIV,KORD,NOBS,RK,H,IH,H,G,V,H1,H2,H3,SCV,TERM1,TERM2,TERM3 ;


  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;


  RK = 1 / (2* SQRT(PI)) ;


  IH = 1 ;
  FORMAT /RD 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    G = H ;
    V = RK / (NOBS * H) ;
    H1 = SQRT(2 * G^2 + 2 * H^2) ;
    H2 = SQRT(2 * G^2 + H^2) ;
    H3 = G * SQRT(2) ;
    TERM1 = NMI2HBW(DIFWTS,A,B,H1,DERIV,KORD,DEL) ;
    TERM2 = NMI2HBW(DIFWTS,A,B,H2,DERIV,KORD,DEL) ;
    TERM3 = NMI2HBW(DIFWTS,A,B,H3,DERIV,KORD,DEL) ;
    IF  BF > .5 ;   /*  DOING SMOOTHED BOOTSTRAP VERSION  */
      V = V - (TERM1 / NOBS) ;
    ENDIF ;
    IF IH == 1 ;
      SCV = (V + TERM1 - 2 * TERM2 + TERM3) ;
    ELSE ;
      SCV = SCV|(V + TERM1 - 2 * TERM2 + TERM3) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(SCV) ;
ENDP;
/* ======================== END PROCEDURE NMTAYBW ======================== */
