/* =========================== START PROC NMTCV ======================== */
PROC NMTCV(DATA,HGRID,NDROP) ;
   /*  DIRECT MATRIX CALCULATION OF      */
   /*               FELUCH AND KORNACKI'S MODIFIED CROSS-VALIDATION  */
   /*  DATA ARE A COLUMN VECTOR OF X'S  */
   /*  CAUTION: THIS USES n BY n MATRICES,              */
   /*          SO CAN EASILY FILL WORKSPACE FOR n TOO LARGE  */
   /*  NDROP IS THE NUMBER OF SMALLEST SPACINGS, FROM n*(n-1), TO DROP  */
   /*          SHOULD BE AN EVEN NUMBER    */
   /*  ASSUMES THE STANDARD NORMAL KERNEL  */
   /*  OUTPUT IS A VECTOR OF VALUES OF TCV       */

 LOCAL N,NH,IK2,R2,VTCV,IH,H,MDIF,DDIF,TCV,DTCV ;

 N = ROWS(DATA) ;
 NH = ROWS(HGRID) ;

 IK2 = 1 / (2 * SQRT(PI)) ;     /*  INTEGRAL OF K SQUARED  */
 R2 = SQRT(2) ;

 VTCV = ZEROS(NH,1) ;
 IH = 1 ;
 DO WHILE IH <= NH ;
   "WORKING ON H NUMBER" IH ;
       /*  CAUTION: THIS SCREEN WRITE CAN SLOW DOWN PROGRAMS,
               BE CAREFUL ABOUT INCLUDING THIS KIND OF THING  */
   H = HGRID[IH] ;

   MDIF = DATA - DATA' ;          /*  MATRIX OF DIFFERENCES  */
   DDIF = VECH(MDIF) ;            /*  LOWER TRIANGULAR PART  */
   DDIF = SORTC(ABS(DDIF),1) ;
   DDIF = DDIF[N+1:N+NDROP/2] ;       /*  SMALLEST SPACINGS  */

   MDIF = MDIF / H ;
   DDIF = DDIF / H ;

   TCV = PDFN(MDIF / R2) / R2 ;    /*  CONVOLUTION OF GAUSSIAN KERNELS  */
   TCV = TCV - 2 * PDFN(MDIF) ;
   DTCV = -2 * PDFN(DDIF) ;

   TCV = DIAGRV(TCV,ZEROS(N,1)) ;    /*  REMOVE DIAGONAL  */
   TCV = SUMC(SUMC(TCV)) ;      /*  DOUBLE SUMMATION  */
   DTCV = SUMC(SUMC(DTCV)) ;
   TCV = IK2 / (N * H)  +  TCV / (N * (N-1) * H) ;
   TCV = TCV - 2 * DTCV / (N * (N-1) * H) ;

   VTCV[IH] = TCV ;

   IH = IH + 1 ;
 ENDO ;


 RETP(VTCV) ;
ENDP ;
/* ============================ END PROC NMTCV ======================== */
