/* =========================== START PROC NMTCVBW ======================== */
PROC (1)=NMTCVBW(DIFWTS,A,B,HGRID,NDROP) ;
    /*  THIS IS A BINNED CALCULATION OF      */
    /*         FELUCH AND KORNACKI'S MODIFIED CROSS-VALIDATION  */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  NDROP IS THE NUMBER OF SMALLEST SPACINGS, FROM n*(n-1), TO DROP  */
    /*          SHOULD BE AN EVEN NUMBER    */
    /*  NOT THE BEST FOR SPEED IN SIMULATION   */
    /*  FOR REAL SPEED, SHOULD SAVE KERNEL VALUES  */

  LOCAL NOBS,DERIV,KORD,IK2,D,IH,H,HR2,CV,TERM1,
       TRNC,NBIN,NOBS,SH,ARG,KERNEL,CDWTS,ICUT,MDIFWTS,TERM2 ;

  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  DERIV = 0 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  IK2 = 1 / (2 * SQRT(PI)) ;     /*  INTEGRAL OF K SQUARED  */
  D = 1 / 2 ;    /*  (1/2)*INTEGRAL OF K^2   */

  IH = 1 ;
  FORMAT 1,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    "WORKING ON H # " IH ;
    H = HGRID[IH,1] ;
    HR2 = H * SQRT(2) ;
    TERM1 = NMI2HBW(DIFWTS,A,B,HR2,DERIV,KORD,1) ;  /* INCLUDE DIAGONALS */
    TERM1 = TERM1 * (NOBS / (NOBS - 1)) ;
                      /*  "U-STATISTIC" OFF DIAGONALS MODIFICATION  */
    TERM1 = TERM1 - IK2 / (NOBS * (NOBS - 1) * H) ;
                      /*  "U-STATISTIC" OFF DIAGONALS MODIFICATION  */

    /*         THIS PART COPIED FROM NMI2HBW.G       */
      TRNC = 10^(-25) ;     /*  SET FINAL VALUE TO THIS IF BELOW  */
      NBIN = ROWS(DIFWTS) ;
      SH = H * (NBIN / (B - A)) ;  /* SCALE H TO ADJUST FOR FUNNY DATA SCALE */
      ARG = SEQA(0,1,NBIN) / SH ;
      KERNEL = NORM(ARG) ;

    /*          DO THE TRUNCATION             */
    CDWTS = CUMSUMC(DIFWTS) - (NOBS + NDROP) ;
    ICUT = MAXINDC(CDWTS .>= 0) ;     /* INDEX TO TRUNCATE AT */
    MDIFWTS = DIFWTS ;
    IF ICUT > 1 ;     /*  TRUNCATE COMPLETELY THESE ENTRIES  */
      MDIFWTS[1:(ICUT-1)] = ZEROS((ICUT-1),1) ;
    ENDIF ;
    MDIFWTS[ICUT] = CDWTS[ICUT] ;
                      /*  USE PART OF THE  ICUT  ENTRY ABOVE THRESHOLD  */


      TERM2 = MDIFWTS' * KERNEL ;            /*  INCLUSIVE DOUBLE SUM  */
      TERM2 = TERM2 / (NOBS * (NOBS-1) * H) ;

      IF TERM2 <= TRNC ;
        TERM2 = TRNC ;
      ENDIF ;

    IF IH == 1 ;
      CV = TERM1 - 2 * TERM2 ;
    ELSE ;
      CV = CV|(TERM1 - 2 * TERM2) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  RETP(CV) ;
ENDP;
/* ======================== END PROCEDURE NMTCVBW ======================== */
