/* =========================== START PROC NMTIF2 ======================== */
PROC NMTIF2(MU,SIG2,W,LEFT,RIGHT) ;
    /*  THIS CALCULATES INTEGRATED, SQUARED, TRUNCATED (AND RESCALED)  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  LEFT AND RIGHT ARE ENDPOINTS OF INTERVAL TO TRUNCATE TO  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */

  LOCAL SIG,TIF,MSIGA,MSIGB,MMU,ARG,M,OUT ;

  SIG = SQRT(SIG2) ;
  TIF = NMCDF(LEFT|RIGHT,MU,SIG2,W) ;
    TIF = TIF[2,1] - TIF[1,1] ;

  MSIGA = SQRT(SIG2' + SIG2) ;
  MSIGB = (SIG' .* SIG) ./ MSIGA ;

  MMU = (SIG2' .* MU) + (SIG2 .* MU') ;
  MMU = MMU ./ (SIG2' + SIG2) ;

    ARG = (RIGHT - MMU) ./ MSIGB ;
  M = CDFN(ARG) ;
    ARG = (LEFT - MMU) ./ MSIGB ;
  M = M - CDFN(ARG) ;

    ARG = (MU - MU') ./ MSIGA ;
  M = M .* (NORM(ARG) ./ MSIGA) ;

  OUT = W' * M * W ;

  OUT = OUT / TIF^2 ;

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC NMTIF2 ======================== */
