/* =========================== START PROC OSF ======================== */
PROC OSF(XGRID,FC,RIGHT,EN) ;
    /*  THIS CALCULATES THE ORTHOGONAL COMPONENTS OF A DENSITY ESTIMATE  */
    /*  XGRID IS SET OF PLACES TO EVALUATE THE EST   */
    /*  FC ARE THE FOURIER COEFFICIENTS (ESTIMATED OR TRUE)   */
    /*            THESE SHOULD BE IN A Kx2 MATRIX, WITH THE 1ST   */
    /*            COLUMN FOR THE COS TERMS, 2ND FOR THE SIN'S   */
    /*  RIGHT GIVES THE ENDPOINTS OF THE SYMMETRIC INTERVAL [RIGHT,RIGHT]  */
    /*  RETURN IS A MATRIX OF VALUES, WHERE ROWS CORRESPOND TO ENTRIES  */
    /*        OF XGRID, COLS CORRESPOND TO NUMBER OF SIN (AND ALSO COS)  */
    /*        TERMS USED, STARTING AT 0, SO EN+1 COLUMNS  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL OUTM,N,ARG,NEWCOL  ;

  OUTM = ONES(ROWS(XGRID),1) ;
  OUTM = OUTM / (2 * RIGHT) ;    /*  0TH BASIS FUNCTION * 0TH FC  */

  N = 1 ;
  DO WHILE N <= EN ;
    ARG = (PI * N * XGRID) / RIGHT ;
    NEWCOL = FC[N,1] * COS(ARG) / SQRT(RIGHT) ;
                                     /*  NTH COS BASIS * NTH COS FC  */
    NEWCOL = NEWCOL + (FC[N,2] * SIN(ARG) / SQRT(RIGHT)) ;
                                     /*  NTH SIN BASIS * NTH SIN FC  */
    NEWCOL = OUTM[.,COLS(OUTM)] + NEWCOL ;
    OUTM = OUTM~NEWCOL ;

    N = N + 1 ;
  ENDO ;

  RETP(OUTM) ;
ENDP ;
/* ============================ END PROC OSF ======================== */
