/* =========================== START PROC OSF1 ======================== */
PROC OSF1(XGRID,FC,RIGHT,WTS,N,PARM) ;
    /*  THIS CALCULATES ONE ORTHOGONAL SERIES DENSITY ESTIMATE  */
    /*  OF PROJECTION TYPE (I.E. ALL WEIGHTS 0 OR 1)  */
    /*  XGRID IS SET OF PLACES TO EVALUATE THE EST   */
    /*  FC ARE THE FOURIER COEFFICIENTS (ESTIMATED OR TRUE)   */
    /*            THESE SHOULD BE IN A Kx2 MATRIX, WITH THE 1ST   */
    /*            COLUMN FOR THE COS TERMS, 2ND FOR THE SIN'S   */
    /*            THERE MUST BE AT LEAST  N  OF THESE  */
    /*  RIGHT GIVES THE ENDPOINTS OF THE SYMMETRIC INTERVAL [-RIGHT,RIGHT] */
    /*  WTS ARE A Kx2 MATRIX OF WEIGHTS TO INCLUDE, FOR THINGS LIKE  */
    /*         LINEAR ESTIMATES, NOT USED FOR PARM > 0  */
    /*  N IS THE NUMBER OF TERMS OVER WHICH TO EVALUATE,  */
    /*         I.E. NUMBER OF COS (SAME AS SIN) TERMS, UNUSED FOR PARM = 0 */
    /*  PARM ALLOWS CUTOFFS,    */
    /*      = 0 FOR FULL LINEAR ESTIMTOR  */
    /*      = 1 FOR PROJECTION ESTIMATOR WITH BOTH COS'S AND SIN'S  */
    /*      = 2 FOR PROJECTION ESTIMATOR WITH JUST COS'S  */
    /*      = 3 FOR PROJECTION ESTIMATOR WITH JUST SIN'S  */
    /*  RETURN IS A VECTOR OF VALUES, WHERE ROWS  */
    /*          CORRESPOND TO ENTRIES OF XGRID  */
  LOCAL OUT,J,ARG  ;

  OUT = ONES(ROWS(XGRID),1) ;
  OUT = OUT / (2 * RIGHT) ;    /*  0TH BASIS FUNCTION * 0TH FC  */

  IF PARM == 0 ;     /*  LINEAR ESTIMATOR, USE WEIGHTS  */
    J = 1 ;
    DO WHILE J <= ROWS(FC) ;
      ARG = (PI * J * XGRID) / RIGHT ;
      OUT = OUT + (WTS[J,1] * FC[J,1] * COS(ARG) / SQRT(RIGHT)) ;
                                     /*  NTH COS BASIS * NTH COS FC * WT  */
      OUT = OUT + (WTS[J,2] * FC[J,2] * SIN(ARG) / SQRT(RIGHT)) ;
                                     /*  NTH SIN BASIS * NTH SIN FC * WT  */
      J = J + 1 ;
    ENDO ;
  ELSEIF PARM == 1 ;     /*  PROJECTION ESTIMATOR, USE BOTH TYPE TERMS  */
    J = 1 ;
    DO WHILE J <= N ;
      ARG = (PI * J * XGRID) / RIGHT ;
      OUT = OUT + (FC[J,1] * COS(ARG) / SQRT(RIGHT)) ;
                                       /*  NTH COS BASIS * NTH COS FC  */
      OUT = OUT + (FC[J,2] * SIN(ARG) / SQRT(RIGHT)) ;
                                       /*  NTH SIN BASIS * NTH SIN FC  */
      J = J + 1 ;
    ENDO ;
  ELSEIF PARM == 2 ;     /*  PROJECTION ESTIMATOR, USE COS TERMS ONLY  */
    J = 1 ;
    DO WHILE J <= N ;
      ARG = (PI * J * XGRID) / RIGHT ;
      OUT = OUT + (FC[J,1] * COS(ARG) / SQRT(RIGHT)) ;
                                       /*  NTH COS BASIS * NTH COS FC  */
      J = J + 1 ;
    ENDO ;
  ELSEIF PARM == 3 ;     /*  PROJECTION ESTIMATOR, USE SIN'S ONLY  */
    J = 1 ;
    DO WHILE J <= N ;
      ARG = (PI * J * XGRID) / RIGHT ;
      OUT = OUT + (FC[J,2] * SIN(ARG) / SQRT(RIGHT)) ;
                                       /*  NTH SIN BASIS * NTH SIN FC  */
      J = J + 1 ;
    ENDO ;
  ENDIF ;

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC OSF1 ======================== */
