/* =========================== START PROC OSFC ======================== */
PROC OSFC(MU,SIG2,W,RIGHT,NX) ;
    /*  THIS CALCULATES DISCRETE (I.E.  FFT) FOURIER COEFFICIENTS   */
    /*  FOR A NORMAL MIXTURE DENSITY   */
    /*  COEFFICIENTS ARE ADJUSTED TO BE CORRECT FOR AN ORTHONORMAL  */
    /*  TRIG BASIS ON [-RIGHT,RIGHT]   */
    /*  WHERE THE DENSITY IS CHOPPED   */
    /*  NX IS NUMBER OF GRID POINTS FOR FFT (MUST BE A POWER OF 2)   */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
    /*  RETURN HAS 1ST NX/2-1 COEFFS OF SIN IN FIRST COL, COS IN 2ND  */
    /*  NOTE ZERO-TH FOURIER COEFF IS OMMITTED, BECAUSE IT IS  */
    /*       ESSENTIALLY 1/SQRT(RIGHT)       */

  LOCAL INCX,XGRID,F,WT,JR,JI,FC,WTS ;

  INCX = 2 * RIGHT / NX ;        /*  START AT X_0, GO TO X_N-1   */
  XGRID = SEQA(-RIGHT,INCX,NX) ;

  F = NMF2(XGRID,MU,SIG2,W) ;          /*  DIGITIZED DENSITY  */
    WT = NMCDF((-RIGHT)|RIGHT,MU,SIG2,W) ;
    WT = WT[2,1] - WT[1,1] ;
  F = F ./ WT ;

  { JR,JI } = FFT(F) ;
  JR = JR[1:NX/2+1] ;
  JI = JI[1:NX/2+1] ;
    F = 0 ;     /*  TO SAVE SPACE  */

  FC = JR[2:NX/2]~JI[2:NX/2] ;
                  /*  COEFF'S OF COS IN 1ST COLUMN, SIN IN 2ND  */
    WTS = SEQM(-1,-1,NX/2-1) ;
    WTS = WTS~SEQM(1,-1,NX/2-1) ;
  FC = FC .* WTS ;              /*  ADJUST FOR SYMMETRIC INTERVAL  */
  FC = FC .* (2* SQRT(RIGHT)) ;      /*  ADJUST FOR INTERVAL LENGTHS  */

  RETP(FC) ;
ENDP ;
/* ============================ END PROC OSFC ======================== */
