/* =========================== START PROC OSFCH ======================== */
PROC OSFCH(DATA,NTERM,NBIN,RIGHT,BINPARM) ;
    /*  THIS ESTIMATES FOURIER COEFFICIENTS  */
    /*  FROM A DATA SET   */
    /*  NTERM IS THE NUMBER OF FOURIER COEFFICIENTS TO ESTIMATE   */
    /*  NBIN IS NUMBER OF BINS TO USE FOR FFT, MUST BE A POWER OF 2  */
    /*  COEFFICIENTS ARE ADJUSTED TO BE CORRECT FOR AN ORTHONORMAL  */
    /*  TRIG BASIS ON [-RIGHT,RIGHT]   */
    /*  RETURN HAS 1ST NTERM COEFFS OF COS IN FIRST COL, SIN IN 2ND  */
    /*  NOTE ZERO-TH FOURIER COEFF IS OMMITTED, BECAUSE IT IS  */
    /*       ESSENTIALLY 1/SQRT(RIGHT)       */
    /*  BINPARM SPECIFIES WHETHER OR NOT TO BIN  */
    /*  BINPARM = -1 FOR DIRECT CALCULATION  */
    /*          = 0 FOR A DEFAULT CHOICE TO BE MADE  */
    /*          = 1 FOR FFT APPROX  */

  LOCAL BP,NOBS,ITERM,ARG,CFC,SFC,OUT,INC,BINCTS,JR,JI,WTS ;

  NOBS = ROWS(DATA) ;

  IF BINPARM == 0 ;
    IF (NOBS <= 1001 AND NTERM <= 6) OR (NOBS <= 101 AND NTERM <= 40) ;
      BP = -1 ;        /*  DO DIRECT METHOD  */
    ELSE ;
      BP = 1 ;        /*  DO FFT METHOD  */
    ENDIF ;
  ELSE ;
    BP = BINPARM ;
  ENDIF ;

  IF BP < 0 ;
    ITERM = 1 ;
    DO WHILE ITERM <= NTERM ;

      ARG = (PI * ITERM * DATA) / RIGHT ;
      CFC = COS(ARG) ;
      CFC = SUMC(CFC) / (NOBS * SQRT(RIGHT)) ;
      SFC = SIN(ARG) ;
      SFC = SUMC(SFC) / (NOBS * SQRT(RIGHT)) ;

      IF ITERM == 1 ;
        OUT = CFC~SFC ;
      ELSE ;
        OUT = OUT|(CFC~SFC) ;
      ENDIF ;

      ITERM = ITERM + 1 ;
    ENDO ;
  ELSE ;

      INC = (2 * RIGHT) / NBIN ;   /*  RECALL INTERVAL LENGTH = 2 * RIGHT  */
    BINCTS = NMLBIN(DATA,-RIGHT,RIGHT-INC,NBIN) ;

    { JR,JI } = FFT(BINCTS) ;
    JR = JR[2:NTERM+1,1] ;
    JI = JI[2:NTERM+1,1] ;
                    /*  CUTOFF XBAR AND 0, AT FRONT, UNNEEDED TERMS AT END  */
    OUT = JR~JI ;
                    /*  COEFF'S OF COS IN 1ST COLUMN, SIN IN 2ND  */
      WTS = SEQM(-1,-1,NTERM) ;
      WTS = WTS~SEQM(1,-1,NTERM) ;
    OUT = OUT .* WTS ;              /*  ADJUST FOR SYMMETRIC INTERVAL  */
    OUT = OUT ./ SQRT(RIGHT) ;      /*  ADJUST FOR INTERVAL LENGTHS  */
    OUT = OUT * (NBIN / NOBS) ;     /*  ADJUST FOR "N^(-1)" IN FFT  */
                                    /*  BEING NBIN, NOT NOBS     */

  ENDIF ;

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC OSFCH ======================== */
