/* =========================== START PROC OSMRISK1 ======================== */
PROC OSMRISK1(FC,PARM,NOBSGRID,MAXN,RIGHT,IF2) ;
    /*  THIS CALCULATES MINIMUM RISK OF PROJECTION VERSION   */
    /*  (I.E. ALL WEIGHTS, OR ALL SIN WEIGHTS, OR ALL COS WEIGHT)  */
    /*  OF FOURIER ORTHOGONAL SERIES ESTIMATOR  */
    /*  FC IS A MATRIX OF FOURIER COEFFICIENTS, 1ST COL FOR COS,  */
    /*                                  2ND FOR SIN  */
    /*  PARM IS 0 FOR BOTH COS AND SIN TERMS INCLUDED,  */
    /*          1 FOR COS TERMS ONLY    */
    /*          2 FOR SIN TERMS ONLY    */
    /*  NOBSGRID IS A VECTOR OF INPUT SAMPLE SIZES   */
    /*  ENOBS IS THE ENDING VALUE FOR NOBS (SAMPLE SIZE)  */
    /*  MAXN IS MAXIMUM NUMBER OF COS TERMS (SAME AS SIN TERMS)  */
    /*          TO INCLUDE IN GRIDSEARCH     */
    /*  RIGHT IS RIGHT ENDPOINT OF SYMMETRIC INTERVAL [-RIGHT,RIGHT]  */
    /*  IF2 IS THE INTEGRAL OF F^2  */
    /*  RETURN IS MATRIX WHERE FIRST COLUMN GIVES SAMPLE SIZE,  */
    /*          SECOND COLUMN GIVES NUMBER OF TERMS TO MIN,   */
    /*          THIRD COLUMN GIVES MINIMUM RISK   */

  LOCAL VTERM1,VTERM2,POWER,VTERM3,INOBS,NOBS,VRISK,NMIN,RMIN ;

  VTERM1 = SEQA(1,1,MAXN) / RIGHT ;
  IF PARM >= 1 ;
    VTERM1 = VTERM1 / 2 ;
  ENDIF ;

  VTERM2 = (IF2 - 1 / (2 * RIGHT)) * ONES(MAXN,1) ;

    POWER = FC .* FC ;
    POWER = POWER[1:MAXN,.] ;
    IF PARM == 1 ;
      POWER = POWER[.,1] ;
    ELSEIF PARM == 2 ;
      POWER = POWER[.,2] ;
    ELSE ;
      POWER = POWER[.,1] + POWER[.,2] ;
    ENDIF ;
  VTERM3 = CUMSUMC(POWER) ;
    POWER = 0 ;    /* TO SAVE SPACE  */


  INOBS = 1 ;
  DO WHILE INOBS <= ROWS(NOBSGRID) ;

    NOBS = NOBSGRID[INOBS,1] ;

    VRISK = (VTERM1 / NOBS) + VTERM2 - ((1 + 1 / NOBS) * VTERM3) ;

    IF INOBS == 1 ;
      NMIN = MININDC(VRISK) ;
      RMIN = VRISK[NMIN[INOBS,1],1] ;
    ELSE ;
      NMIN = NMIN|MININDC(VRISK) ;
      RMIN = RMIN|VRISK[NMIN[INOBS,1],1] ;
    ENDIF ;

    INOBS = INOBS + 1 ;
  ENDO ;


  RETP(NOBSGRID~NMIN~RMIN) ;
ENDP ;
/* ============================ END PROC OSMRISK1 ======================== */
