/* =========================== START PROC OSMRISK2 ======================== */
PROC OSMRISK2(FC,NOBSGRID,RIGHT) ;
    /*  THIS CALCULATES MINIMUM RISK OF BEST LINEAR VERSION   */
    /*     (I.E. ALL WEIGHTS BEST POSSIBLE)   */
    /*     OF FOURIER ORTHOGONAL SERIES ESTIMATOR  */
    /*  FC IS A MATRIX OF FOURIER COEFFICIENTS, 1ST COL FOR COS,  */
    /*                                  2ND FOR SIN  */
    /*  NOBSGRID IS A GRID OF NOBS VALUES WHERE MINS SHOULD BE FOUND  */
    /*  SNOBS IS THE STARTING VALUE FOR NOBS (SAMPLE SIZE)  */
    /*  ENOBS IS THE ENDING VALUE FOR NOBS (SAMPLE SIZE)  */
    /*  RIGHT IS RIGHT ENDPOINT OF SYMMETRIC INTERVAL [-RIGHT,RIGHT]  */
    /*  RETURN IS MATRIX WHERE FIRST COLUMN GIVES INPUT    */
    /*         GRID OF SAMPLE SIZES, SECOND COLUMN GIVES MINIMUM RISK   */

  LOCAL NFC,TSQ,T2J,FACTC,FACTS,FACT,INOBS,NOBS,RISK,DENOM,VRISK  ;

  NFC = FLOOR(ROWS(FC) / 2) ;

  TSQ = FC[1:NFC,.] ;
  TSQ = TSQ .* TSQ ;

    T2J = FC[.,1] ;
    T2J = RESHAPE(T2J,NFC,2) ;
    T2J = T2J[.,2] ;
  FACTC = (1 / (2 * RIGHT)) ;
  FACTC = FACTC + (1 / (2 * SQRT(RIGHT))) * T2J ;
  FACTC = FACTC - TSQ[.,1] ;
  FACTS = (1 / (2 * RIGHT)) ;
  FACTS = FACTS - (1 / (2 * SQRT(RIGHT))) * T2J ;
  FACTS = FACTS - TSQ[.,2] ;
  FACT = FACTC~FACTS ;
    T2J = 0 ; FACTS = 0 ; FACTC = 0 ;    /*  TO SAVE SPACE  */

  INOBS = 1 ;
  DO WHILE INOBS <= ROWS(NOBSGRID) ;

    NOBS = NOBSGRID[INOBS,1] ;
    RISK = (TSQ .* FACT) ;
    DENOM = TSQ + (FACT / NOBS) ;
    RISK = RISK ./ DENOM ;
    RISK = SUMC(SUMC(RISK)) ;
    RISK = RISK / NOBS ;

    IF INOBS == 1 ;
      VRISK = RISK ;
    ELSE ;
      VRISK = VRISK|RISK ;
    ENDIF ;

    INOBS = INOBS + 1 ;
  ENDO ;

  RETP(NOBSGRID~VRISK) ;
ENDP ;
/* ============================ END PROC OSMRISK2 ======================== */
