/* =========================== START PROC OSRISK1 ======================== */
PROC OSRISK1(FC,WTS,SNTERM,ENTERM,NOBS,RIGHT,IF2) ;
    /*  THIS CALCULATES RISK OF FOURIER ORTHOGONAL SERIES ESTIMATOR  */
    /*  FC IS A MATRIX OF FOURIER COEFFICIENTS, 1ST COL FOR COS,  */
    /*                                  2ND FOR SIN  */
    /*  WTS IS A MATRIX OF WEIGHTS FOR THE "LINEAR" ESTIMATOR  */
    /*        ENTRIES CORRESPOND TO FIRST ROWS OF FC    */
    /*  SNTERM IS THE STARTING VALUE FOR NUMBER OF SIN'S  */
    /*             (SAME AS NUMBER COS'S) USED    */
    /*  ENTERM IS THE ENDING VALUE FOR NUMBER OF SIN'S  */
    /*             (SAME AS NUMBER COS'S) USED    */
    /*             MUST BE <= ROWS(FC/2)  */
    /*  WTS MUST HAVE AT LEAST ENTERM ENTRIES  */
    /*  NOBS IS THE SAMPLE SIZE  */
    /*  RIGHT IS RIGHT ENDPOINT OF SYMMETRIC INTERVAL [-RIGHT,RIGHT]  */
    /*  IF2 IS THE INTEGRAL OF F^2  */

  LOCAL N,TEMP,I2RTT,TERM1,TERM2,TERM3,TERM4,TERM5,RISK,NEWRISK ;

  N = SNTERM ;    /* NUMBER OF TERM SIN'S (I.E. COS'S) USED IN EST  */


    TEMP = RESHAPE(FC[1:2*N,1],N,2) ;
    TEMP = TEMP[.,2] ;                 /*  EVEN COS FC'S  */
  I2RTT = TEMP ./ (2 * SQRT(RIGHT)) ;

    TEMP = FC[1:N,1] ;           /*  FC'S FOR COS TERMS  */
  TERM1 = 1 / (2 * RIGHT) + I2RTT - TEMP .* TEMP ;
    TEMP = WTS[1:N,1] ;        /*  WTS FOR COS TERMS  */
    TEMP = TEMP .* TEMP ;
  TERM1 = TEMP' * TERM1 ;
  TERM1 = TERM1 / NOBS ;
  RISK = TERM1 ;

    TEMP = FC[1:N,2] ;           /*  FC'S FOR SIN TERMS  */
  TERM2 = 1 / (2 * RIGHT) - I2RTT - TEMP .* TEMP ;
    TEMP = WTS[1:N,2] ;        /*  WTS FOR SIN TERMS  */
    TEMP = TEMP .* TEMP ;
  TERM2 = TEMP' * TERM2 ;
  TERM2 = TERM2 / NOBS ;
  RISK = RISK + TERM2 ;
    I2RTT = 0 ;    /* TO SAVE SPACE */

    TEMP = FC[1:N,1] ;           /*  FC'S FOR COS TERMS  */
  TERM3 = TEMP .* TEMP ;
    TEMP = 1 - WTS[1:N,1] ;        /*  WTS FOR COS TERMS  */
    TEMP = TEMP .* TEMP ;
  TERM3 = TEMP' * TERM3 ;
  RISK = RISK + TERM3 ;

    TEMP = FC[1:N,2] ;           /*  FC'S FOR SIN TERMS  */
  TERM4 = TEMP .* TEMP ;
    TEMP = 1 - WTS[1:N,2] ;        /*  WTS FOR SIN TERMS  */
    TEMP = TEMP .* TEMP ;
  TERM4 = TEMP' * TERM4 ;
  RISK = RISK + TERM4 ;

  TERM5 = FC[1:N,1]' * FC[1:N,1] ;                 /*  COS TERMS  */
  TERM5 = TERM5 + (FC[1:N,2]' * FC[1:N,2]) ;       /*  SIN TERMS  */
  TERM5 = TERM5 + 1 / (2 * RIGHT) ;
  TERM5 = IF2 - TERM5 ;
  RISK = RISK + TERM5 ;


  DO WHILE N <= (ENTERM - 1) ;
      N = N + 1 ;

      I2RTT = FC[2*N,1] ./ (2 * SQRT(RIGHT)) ;

      TERM1 = 1 / (2 * RIGHT) + I2RTT - FC[N,1].*FC[N,1] ;
                                               /*  FC FOR COS TERMS  */
        TEMP = WTS[N,1] .* WTS[N,1] ;          /*  WT FOR COS TERMS  */
      TERM1 = TEMP' * TERM1 ;
      TERM1 = TERM1 / NOBS ;

      TERM2 = 1 / (2 * RIGHT) - I2RTT - FC[N,2].*FC[N,2] ;
                                               /*  FC FOR SIN TERMS  */
        TEMP = WTS[N,2] .* WTS[N,2] ;          /*  WT FOR SIN TERMS  */
      TERM2 = TEMP' * TERM2 ;
      TERM2 = TERM2 / NOBS ;

      TERM3 = FC[N,1] .* FC[N,1] ;    /*  FC'S FOR COS TERMS  */
        TEMP = 1 - WTS[N,1] ;         /*  WTS FOR COS TERMS  */
        TEMP = TEMP .* TEMP ;
      TERM3 = TEMP' * TERM3 ;

      TERM4 = FC[N,2] .* FC[N,2] ;     /*  FC'S FOR SIN TERMS  */
        TEMP = 1 - WTS[N,2] ;          /*  WTS FOR SIN TERMS  */
        TEMP = TEMP .* TEMP ;
      TERM4 = TEMP' * TERM4 ;

      TERM5 = FC[N,1]' * FC[N,1] ;                /*  COS TERMS  */
      TERM5 = TERM5 + (FC[N,2]' * FC[N,2]) ;       /*  SIN TERMS  */
      TERM5 = -TERM5 ;

      NEWRISK = RISK[ROWS(RISK),1] + TERM1 + TERM2 + TERM3 + TERM4 + TERM5 ;
      RISK = RISK|NEWRISK ;
  ENDO ;

  RETP(RISK) ;
ENDP ;
/* ============================ END PROC OSRISK1 ======================== */
