/* =========================== START PROC PHIINV3 ======================== */
PROC PHIINV3(P,NSTEP) ;
    /*  THIS CALCULATES INVERSE OF THE CDF OF THE STANDARD NORMAL  */
    /*  GIVEN A COLUMN VECTOR OF ARGUMENTS, P  */
    /*  AND A NUMBER OF IMPROVEMENT STEPS TO MAKE, NSTEP  */
    /*  IN ALL CASES TRIED, NSTEP = 3 GAVE 14 DIGIT ACCURACY, */
    /*  NSTEP > 4 WILL GIVE ONLY WASTED STEPS  */
    /*  ALGORITHM STARTS AT THE ANSWER GIVEN BY RUPPERT'S PHIINV  */
    /*  AND DOES NSTEP SIMPLE NEWTON METHOD STEPS  */
    /*  REQUIRES PROCS PHIINV AND PHIINV2 ACCESSIBLE  */

  LOCAL Q,ISTEP ;

  Q = PHIINV(P) ;
  ISTEP = 1 ;
  DO WHILE ISTEP <= NSTEP ;
    Q = Q - (CDFN(Q) - P) ./ PDFN(Q) ;
    ISTEP = ISTEP + 1 ;
  ENDO ;

  RETP(Q) ;
ENDP ;
/* ============================ END PROC PHIINV3 ======================== */

