/*  C:\GAUSS\PRG\ROOTF.PRC  */

         /*  ROOTFINDING PROCEDURE  */
                   /*  THE ARGUMENTS ARE THE X AND Y COORDINATES OF A FUNCTION
                       FOR WHICH IT IS DESIRED TO FIND THE ROOT (IN CASE OF
                       MULTIPLE ROOTS, IT FINDS THE LAST FOR WHICH THE SIGN
                       CHANGE IS - TO +
                       THIS ASSUMES THE X'S ARE ORDERED
                       RETURNED VALUE IS A VECTOR CONTAINING THE MINIMIZING
                       VALUE, -1,0,1,5 TO INDICATE IF ENDPOINTS ARE HIT
                       OR A STRANGE CUBIC FIT WAS ENCOUNTERED, AND
                       THE NUMBER OF TIMES THE SIGN CHANGES FROM - TO +   */
PROC (1)=ROOTF(X,Y) ;
   LOCAL NX, YFLAG, YFLAGDIF, JUMPFLAG, NJUMP, I, M, ALPHA, LINROOT, XV, BETA,
            CUBROOT ;
   NX = ROWS(X) ;
     YFLAG = (Y .>= 0) ;           /*  FLAG SITES WHERE Y IS POSITIVE  */
     YFLAGDIF = YFLAG[2:NX,1] - YFLAG[1:(NX-1),1] ;
     JUMPFLAG = (YFLAGDIF .> 0) ;  /*  FLAG INTERVALS WHERE YFLAG INCREASES */
     NJUMP = SUMC(JUMPFLAG) ;
   IF NJUMP == 0 ;
      IF SUMC(YFLAG) == NX ;   /*  DERIV ALWAYS > 0  */
          "  LEFT END WAS HIT" ;
          RETP(X[1,1]|-1|NJUMP) ;  /*  MINR, ENDPT FLAG, NUMBER OF JUMPS  */
      ELSE ;                   /*  DERIV ALWAYS > 0 OR MAX ONLY  */
          "  RIGHT END WAS HIT" ;
          RETP(X[NX,1]|1|NJUMP) ;  /*  MINR, ENDPT FLAG, NUMBER OF JUMPS  */
      ENDIF ;
   ELSE ;
      I = NX - MAXINDC(REV(JUMPFLAG)) ;  /* INDEXES INTERVAL WHERE
                                                   LAST JUMP OCCURS  */
      M = X[I:(I+1),1]~ONES(2,1) ;
      ALPHA = Y[I:(I+1),1] / M ;             /*  COEFFS OF LINEAR FIT  */
      LINROOT = -ALPHA[2,1]/ALPHA[1,1] ;
      IF I == 1 OR I == (NX-1) ;  /* RETURN FIRST GUESS AT ENDS */
         RETP(LINROOT|0|NJUMP) ;  /*  X INTERCEPT OF LINEAR FIT  */
      ELSE ;
         XV = X[(I-1):(I+2),1] ;
         M = (XV.*XV.*XV)~(XV.*XV)~XV~ONES(4,1) ;
         ALPHA = Y[(I-1):(I+2),1] / M ;          /*  COEFFS OF CUBIC FIT  */
         BETA = SEQA(3,-1,3) .* ALPHA[1:3,1] ;   /*  COEFFS OF DERIV  */
         CUBROOT = LINROOT - POLYEVAL(LINROOT,ALPHA)/POLYEVAL(LINROOT,BETA) ;
         IF CUBROOT <= X[I+1,1] AND CUBROOT >= X[I,1] ;
            RETP(CUBROOT|0|NJUMP) ;  /*  RESULT OF ONE STEP NEWTON RAPHSON  */
         ELSE ;
            RETP(LINROOT|5|NJUMP) ;
         ENDIF;
      ENDIF ;
   ENDIF ;
ENDP ;
