/*========================== START PROC RTBISEC ===========================*/
PROC RTBISEC(&F,XLEFT,XRIGHT,XACC,IREL,MAXSTEP,ISHOW) ;
    /*  FINDS ROOTS OF THE FUNCTION REPRESENTED BY THE PROCEDURE F,     */
    /*  WHICH IS ASSUMED TO ACCEPT A SINGLE MATRIX OF ARGUMENTS,        */
    /*  USING A SIMPLE ITERATIVE BISECTION ALGORITHM                    */
    /*  XLEFT AND XRIGHT ARE ENDPOINTS OF AN INTERVAL KNOWN TO BRACKET  */
    /*  A ROOT (BECAUSE THE FUNCTION VALUES ARE KNOWN TO BE + AND -)    */
    /*  XACC IS THE ACCURACY OF THE ANSWER.  THIS IS MEASURED:          */
    /*       ABSOLUTELY   WHEN IREL = 0                                 */
    /*       RELATIVELY   WHEN IREL = 1  (DON'T USE IF ROOT = 0)        */
    /*  THE ITERATION QUITS WHEN MAXSTEP STEPS HAVE BEEN DONE           */
    /*  RESULTS AT EACH STEP ARE WRITTEN TO THE SCREEN, AND RETURN      */
    /*  IS BOTH THE BEST GUESS, PLUS ALL PREVIOUS GUESSES,              */
    /*       UNLESS ISHOW = 0 ;                                         */
    /*  IF FORMATS FOR THE OUTPUT ARE A CONCERN, SET THEM BEFORE THIS   */
  LOCAL F:PROC,FXL,FXR,XP,XN,ACC,ISTEP,XNEW,FXN,VGUESS ;

  FXL = F(XLEFT) ;
  FXR = F(XRIGHT) ;
  IF (FXL <= 0) AND (FXR >= 0) ;
    XP = XRIGHT ;        /* ENDPOINT WHERE F >= 0 */
    XN = XLEFT ;         /* ENDPOINT WHERE F <= 0 */
  ELSEIF (FXL >= 0) AND (FXR <= 0) ;
    XP = XLEFT ;         /* ENDPOINT WHERE F >= 0 */
    XN = XRIGHT ;        /* ENDPOINT WHERE F <= 0 */
  ELSE ;
    "!!!!!    THIS INTERVAL DOES NOT SEEM TO BRACKET A ROOT    !!!!!" ;
    "!!!!!                  SIMPLY RETURNING 0                 !!!!!" ; ? ;
    RETP(0) ;
  ENDIF ;

  IF IREL == 0 ;    /*  ABSOLUTE ERROR  */
    ACC = ABS(XP - XN) ;
  ELSE ;       /*  RELATIVE ERROR   */
    ACC = ABS(XP - XN) / ((ABS(XP) + ABS(XN)) / 2 ) ;
  ENDIF ;

  ISTEP = 1 ;
  DO UNTIL (ACC < 2*XACC) OR (ISTEP > MAXSTEP) ;
    XNEW = (XP + XN) / 2 ;
    FXN = F(XNEW) ;

    IF ISHOW /= 0 ;            /*  KEEP TRACK OF GUESSES  */
      IF ISTEP == 1 ;      VGUESS = XNEW ;
      ELSE ;               VGUESS = XNEW|VGUESS ;    ENDIF ;

      "AT STEP NUMBER " ISTEP "   x = " XNEW "   f(x) = " FXN ;
    ENDIF ;

                /*  NOW UPDATE  */
    IF FXN <= 0 ;
      XN = XNEW ;
    ELSE ;
      XP = XNEW ;
    ENDIF ;

    IF IREL == 0 ;    /*  ABSOLUTE ERROR  */
      ACC = ABS(XP - XN) ;
    ELSE ;       /*  RELATIVE ERROR   */
      ACC = ABS(XP - XN) / ((ABS(XP) + ABS(XN)) / 2 ) ;
    ENDIF ;

    ISTEP = ISTEP + 1 ;
  ENDO ;

  XNEW = (XP + XN) / 2 ;

  IF (ISHOW /= 0) ;
    RETP(XNEW|VGUESS) ;
  ELSE ;
    RETP(XNEW) ;
  ENDIF ;
ENDP ;
/*=========================== END PROC RTBISEC ============================*/
