/*========================== START PROC RTFALPO ==========================*/
PROC RTFALPO(&F,ISAFE,X0,X1,XACC,IREL,MAXSTEP,ISHOW) ;
    /*  FINDS ROOTS OF THE FUNCTION REPRESENTED BY THE PROCEDURE F,     */
    /*  WHICH IS ASSUMED TO ACCEPT A SINGLE MATRIX OF ARGUMENTS,        */
    /*  USES: FALSE POSITION METHOD WHEN      ISAFE = 1                 */
    /*                SECANT METHOD WHEN      ISAFE = 0                 */
    /*  FOR ISAFE = 1, X0 AND X1 ARE ENDPOINTS OF AN INTERVAL KNOWN TO  */
    /*               BRACKET A ROOT (IN SENSE OF + - FUNCTION VALUES)   */
    /*  FOR ISAFE = 0, X0 AND X1 ARE ANY TWO STARTING VALUES            */
    /*  XACC IS THE ACCURACY OF THE ANSWER.  THIS IS MEASURED:          */
    /*       ABSOLUTELY   WHEN IREL = 0                                 */
    /*       RELATIVELY   WHEN IREL = 1  (DON'T USE IF ROOT = 0)        */
    /*  IN BOTH CASES, THIS IS ONLY MEASURED BY THE GAP BETWEEN ROOTS   */
    /*  THE ITERATION QUITS WHEN MAXSTEP STEPS HAVE BEEN DONE           */
    /*  RESULTS AT EACH STEP ARE WRITTEN TO THE SCREEN, AND RETURN      */
    /*  IS BOTH THE BEST GUESS, PLUS ALL PREVIOUS GUESSES,              */
    /*       UNLESS ISHOW = 0 ;                                         */
    /*  IF FORMATS FOR THE OUTPUT ARE A CONCERN, SET THEM BEFORE THIS   */
  LOCAL F:PROC,FX0,FX1,XP,FXP,XN,FXN,XOLD,ACC,
                 ISTEP,DENOM,W,XNEW,FXNEW,VGUESS ;

  FX0 = F(X0) ;
  FX1 = F(X1) ;
  IF ISAFE == 1 ;    /*  FALSE POSITION METHOD  */
    IF (FX0 <= 0) AND (FX1 >= 0) ;
      XP = X1 ;         /* ENDPOINT WHERE F >= 0 */
      FXP = FX1 ;
      XN = X0 ;         /* ENDPOINT WHERE F <= 0 */
      FXN = FX0 ;
    ELSEIF (FX0 >= 0) AND (FX1 <= 0) ;
      XP = X0 ;         /* ENDPOINT WHERE F >= 0 */
      FXP = FX0 ;
      XN = X1 ;         /* ENDPOINT WHERE F <= 0 */
      FXN = FX1 ;
    ELSE ;
      "!!!!!   THIS INTERVAL DOES NOT SEEM TO BRACKET A ROOT   !!!!!" ;
      "!!!!!                 SIMPLY RETURNING 0                !!!!!" ; ? ;
      RETP(0) ;
    ENDIF ;
  ELSE ;      /*  SECANT METHOD  */
    XP = X0 ;
    FXP = FX0 ;
    XN = X1 ;
    FXN = FX1 ;
  ENDIF ;
  XNEW = X1 ;

  IF IREL == 0 ;    /*  ABSOLUTE ERROR  */
    ACC = ABS(X1 - X0) ;
  ELSE ;       /*  RELATIVE ERROR   */
    ACC = ABS(X1 - X0) / ((ABS(X1) + ABS(X0)) / 2 ) ;
  ENDIF ;

  ISTEP = 1 ;
  DO UNTIL (ACC < 2*XACC) OR (ISTEP > MAXSTEP) ;

    DENOM = FXN - FXP ;
    IF DENOM == 0 ;     /*  GUARD AGAINST DIVISION BY 0  */
      "!!!!!   NOT ENOUGH ACCURACY, OR FUNCTION TOO FLAT   !!!!!" ;
      "!!!!!              SIMPLY RETURNING 0               !!!!!" ; ? ;
      RETP(0) ;
    ENDIF ;
    W = FXN / DENOM ;
    XOLD = XNEW ;      /*  SAVE FOR ACCURACY PURPOSES  */
    XNEW = W * XP + (1 - W) * XN ;
    FXNEW = F(XNEW) ;

    IF ISHOW /= 0 ;            /*  KEEP TRACK OF GUESSES  */
      IF ISTEP == 1 ;      VGUESS = XNEW ;
      ELSE ;               VGUESS = XNEW|VGUESS ;    ENDIF ;

      "AT STEP NUMBER " ISTEP "   x = " XNEW "   f(x) = " FXNEW ;
    ENDIF ;

                  /*  NOW UPDATE  */
    IF ISAFE == 1 ;    /*  FALSE POSITION METHOD  */
      IF FXNEW <= 0 ;
        XN = XNEW ;
        FXN = FXNEW ;
      ELSE ;
        XP = XNEW ;
        FXP = FXNEW ;
      ENDIF ;
    ELSE ;      /*  SECANT METHOD  */
      XP = XN ;
      FXP = FXN ;
      XN = XNEW ;
      FXN = FXNEW ;
    ENDIF ;

    IF IREL == 0 ;    /*  ABSOLUTE ERROR  */
      ACC = ABS(XNEW - XOLD) ;
    ELSE ;       /*  RELATIVE ERROR   */
      ACC = ABS(XNEW - XOLD) / ((ABS(XNEW) + ABS(XOLD)) / 2 ) ;
    ENDIF ;

    ISTEP = ISTEP + 1 ;
  ENDO ;

             /*  ONE LAST UPDATING  */
  DENOM = FXN - FXP ;
  IF DENOM == 0 ;     /*  GUARD AGAINST DIVISION BY 0  */
    "!!!!!   NOT ENOUGH ACCURACY, OR FUNCTION TOO FLAT   !!!!!" ;
    "!!!!!              SIMPLY RETURNING 0               !!!!!" ; ? ;
    RETP(0) ;
  ENDIF ;
  W = FXN / DENOM ;
  XNEW = W * XP + (1 - W) * XN ;

  IF (ISHOW /= 0) ;
    RETP(XNEW|VGUESS) ;
  ELSE ;
    RETP(XNEW) ;
  ENDIF ;
ENDP ;
/*=========================== END PROC RTFALPO ===========================*/
