/* =========================== START PROC SCHMSE ======================== */
PROC SCHMSE(N,MU,SIG2,W,H,G,M) ;
    /*  THIS CALCULATES EXACT RELATIVE BANDWIDTH MSE  */
    /*  THIS ASSUMES G OF THE FORM H = K * N^P * H^M  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
    /*  RETURNS MSE, MEAN AND S D OF BANDWIDTH DISTRIBUTIONS  */
  LOCAL NPAR,RK,C,I,COEFF,MM,SIGT,T,ES,EH,
           I1,I2,MUL,MULP,MULPP,SIGL,SIGLP,SIGLPP,U,COVSS,
           SIGI,SIGIP,VARS,VARH,MSE,DDM,EHHAT,SDHHAT ;

  NPAR = ROWS(MU) ;

  RK = 1 / (2 * SQRT(PI)) ;

  C = ZEROS(3,1) ;
  C[1,1] = M .* G^2 ;
  C[2,1] = -(H^2 + 2 .* M .* G^2) ;
  C[3,1] = H^2 + M .* G^2 ;

  I = SEQA(0,1,3) ;


  COEFF = C .*. (W .*. W) ;        /*  KRONECKER PRODUCTS  */
  MM = ONES(3,1) .*. RESHAPE(MU' - MU,NPAR^2,1) ;
                                   /* RESHAPE IS KRONECKER "DIFF" */
    SIGT = (I .*. ONES(NPAR^2,1)) .* H^2 ;
    SIGT = SIGT + ONES((3 * NPAR^2),1) .* 2 .* G^2 ;
    SIGT = SIGT + ONES(3,1) .*. RESHAPE(SIG2' + SIG2,NPAR^2,1) ;
  SIGT = SQRT(SIGT) ;
    T = MM ./ SIGT ;
  T = (T^2 - 1) .* NORM(T) ./ SIGT^3 ;
  ES = SUMC(COEFF .* T) ;
  ES = 2 .* ES ./ H ;
  COEFF = 0 ; MM = 0 ; SIGT = 0 ; T = 0 ;

  EH = N .* RK - N^2 .* H^2 .* ES ;

  COVSS = 0 ;
  I1 = 1 ;             /*  NEED LOOPS BECAUSE KRONECKER GETS TOO BIG  */
  DO WHILE I1 <= 3 ;
    I2 = 1 ;
    DO WHILE I2 <= 3 ;
      COEFF = W .*. W .*. W ;
      MUL = MU .*. ONES(NPAR^2,1) ;
      MULP = ONES(NPAR,1) .*. MU .*. ONES(NPAR,1) ;
      MULPP = ONES(NPAR^2,1) .*. MU ;
        SIGL = I[I1,1] .* ONES(NPAR^3,1) .* H^2 ;
        SIGL = SIGL + ONES(NPAR^3,1) .* 2 .* G^2 ;
        SIGL = SIGL + SIG2 .*. ONES((NPAR^2),1) ;
      SIGL = SQRT(SIGL) ;
        SIGLP = (I[I2,1] .*. ONES(NPAR^3,1)) .* H^2 ;
        SIGLP = SIGLP + ONES(NPAR^3,1) .* 2 .* G^2 ;
        SIGLP = SIGLP + ONES(NPAR,1) .*. SIG2 .*. ONES(NPAR,1) ;
      SIGLP = SQRT(SIGLP) ;
      SIGLPP = ONES(NPAR^2,1) .*. SQRT(SIG2) ;
      U = NMI3PHI(MUL,SIGL,MULP,SIGLP,MULPP,SIGLPP) ;
      COVSS = COVSS + C[I1,1] .* C[I2,1] .* SUMC(COEFF .* U) ;
      COEFF = 0 ; MUL = 0 ; MULP = 0 ; MULPP = 0 ;
      SIGL = 0 ; SIGLP = 0 ; SIGLPP = 0 ; U = 0 ;
      I2 = I2 + 1 ;
    ENDO ;
    I1 = I1 + 1 ;
  ENDO ;
  COVSS = 4 .* COVSS ./ H^2 ;
  COVSS = COVSS - ES^2 ;


  COEFF = C .*. C .*. W .*. W ;
  MUL = ONES(9,1) .*. MU .*. ONES(NPAR,1) ;
  MULP = ONES((9 * NPAR),1) .*. MU ;
    SIGI = (I .*. ONES(3 * NPAR^2,1)) .* H^2 ;
    SIGI = SIGI + ONES((9 * NPAR^2),1) .* 2 .* G^2 ;
  SIGI = SQRT(SIGI) ;
    SIGIP = (ONES(3,1) .*. I .*. ONES(NPAR^2,1)) .* H^2 ;
    SIGIP = SIGIP + ONES((9 * NPAR^2),1) .* 2 .* G^2 ;
  SIGIP = SQRT(SIGIP) ;
  SIGL = ONES(9,1) .*. SQRT(SIG2) .*. ONES(NPAR,1) ;
  SIGLP = ONES((9 * NPAR),1) .*. SQRT(SIG2) ;
  U = NMI4PHI(SIGI,SIGIP,MUL,SIGL,MULP,SIGLP) ;
  VARS = SUMC(COEFF .* U) ;
  VARS = 4 .* VARS ./ H^2 ;
  VARS = VARS - ES^2 ;
  COEFF = 0 ; MUL = 0 ; MULP = 0 ;
  SIGI = 0 ; SIGIP = 0 ; SIGL = 0 ; SIGLP = 0 ; U = 0 ;

  IF N > 1 ;
    VARH = 4 .* H^4 .* N^3 .* (N-2) .* COVSS ./ (N-1) ;
    VARH = VARH + 2 .* H^4 .* N^3 .* VARS ./ (N-1) ;
  ELSE ;
    VARH = 0 ;
  ENDIF ;

  DDM = ZEROS(1,3) ;
  DDM = NMDMISE(N,H,MU,SIG2,W,2) ;
  DDM = DDM[1,3] ;
  MSE = (EH^2 + VARH) ./ (N^2 .* H^3 .* DDM)^2 ;

  EHHAT = H * (1 + EH / (N^2 * H^3 * DDM)) ;
  SDHHAT = SQRT( VARH / (N^4 * H^4 * DDM^2) ) ;

  RETP(MSE|EHHAT|SDHHAT) ;
ENDP ;
/* ============================ END PROC SCHMSE ======================== */
