/* =========================== START PROC SKSCFH ======================== */
PROC SKSCFH(BINCTS,ENDPTS,VH,WTS,AFLAG,ISHOW) ;
    /*  THIS CALCULATES ABRAMSONS SCALED KERNEL ESTIMATE   */
    /*  USING A BINNED IMPLEMENTATION, AND A NORMAL KERNEL  */
    /*  ENDPTS IS RIGHT|LEFT, THE ENDPTS OF THE BINNING GRID   */
    /*  VH IS A VECTOR OF BANDWIDTHS    */
    /*  WHEN AFLAG = 0, THE SETS OF WTS IS MANUALLY ENTERED   */
    /*                      THROUGH THE NBIN VECTOR WTS   */
    /*  WHEN AFLAG = 1, THE SET OF WTS IS CALCULATED FROM THE DATA,  */
    /*                      USING A PILOT BANDWIDTH IN WTS   */
    /*  ISHOW = 1 PRINTS INFO TO SCREEN,  ISHOW = 0, TURNS THIS OFF  */
    /*  REQUIRES NORM.PRC #INCLUDED        */
  LOCAL NBIN,NOBS,KORD,BINWD,BCENTS,IS,VW,IH,H,FH,J,WH,TERM,SFH ;

  NBIN = ROWS(BINCTS) ;
  NOBS = SUMC(BINCTS) ;
  KORD = 2 ;
  BINWD = (ENDPTS[2,1] - ENDPTS[1,1]) / (NBIN - 1) ;
  BCENTS = SEQA(ENDPTS[1,1],BINWD,NBIN) ;
  IS = (ISHOW /= 0) ;

  IF IS ;
    "RUNNING SKSCFH.G" ;
  ENDIF ;

  IF AFLAG == 1 ;     /*  USE AUTOMATIC SHIFTS  */
    IF IS ;
      "   CALCULATING PILOTS ESTS " ;
    ENDIF ;
    VW = NMFHB(BINCTS,ENDPTS[1,1],ENDPTS[2,1],WTS[1,1],KORD) ;
                       /*  RECALL WTS NOW CONTAINS PILOT BANDWIDTH  */
    IF VW /= 0 ;
      VW = 1 ./ SQRT(VW) ;
    ELSE ;
      "!!!!!     CAREFUL CANNOT DIVIDE BY ZERO, RETURNING 0     !!!!!" ;
      RETP(0) ;
    ENDIF ;
  ELSE ;
    VW = WTS ;
  ENDIF ;

                  /*  NORMALIZE WTS BY MEDIAN  */
  VW = VW / NMMED(VW) ;

  IH = 1 ;
  DO WHILE IH <= ROWS(VH) ;
    H = VH[IH,1] ;
    IF IS ;
      "   WORKING ON H NUMBER " IH "      H = " H ;
    ENDIF ;

    FH = ZEROS(NBIN,1) ;

    J = 1 ;
    DO WHILE J <= NBIN ;
      IF IS ;
        IF FLOOR(J/10) == J/10 ;
          "      WORKING ON ROW NUMBER " J "      OF " NBIN ;
        ENDIF ;
      ENDIF ;
      WH = H * VW[J,1] ;
      TERM = NORM((BCENTS - BCENTS[J,1]) / WH) ;
      TERM = BINCTS[J,1] * TERM / WH ;
      FH = FH + TERM ;
      J = J + 1 ;
    ENDO ;

    IF IH == 1 ;
      SFH = FH ;
    ELSE ;
      SFH = SFH~FH ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;

  SFH = SFH / NOBS ;

  RETP(SFH) ;
ENDP ;
/* ============================ END PROC SKSCFH ======================== */

