/* =========================== START PROC SKSHFH ======================== */
PROC SKSHFH(BINCTS,ENDPTS,VH,SHFTS,AFLAG,ISHOW) ;
    /*  THIS CALCULATES THE SHIFTED KERNEL ESTIMATE   */
    /*  USING A BINNED IMPLEMENTATION, AND A NORMAL KERNEL  */
    /*  ENDPTS IS RIGHT|LEFT, THE ENDPTS OF THE BINNING GRID   */
    /*  VH IS A VECTOR OF BANDWIDTHS    */
    /*  WHEN AFLAG = 0, THE SETS OF SHIFTS IS MANUALLY ENTERED   */
    /*                      THROUGH THE NBIN VECTOR SHFTS   */
    /*  WHEN AFLAG = 1, THE SET OF SHIFTS IS CALCULATED FROM THE DATA,  */
    /*                      USING PILOT BANDWIDTHS GD|G IN SHFTS   */
    /*  ISHOW = 1 PRINTS INFO TO SCREEN,  ISHOW = 0, TURNS THIS OFF  */
  LOCAL NBIN,KORD,DERIV,BINWD,BINCTS,VS,DENOM,IH,H,BCENTS,SFH ;

  NBIN = ROWS(BINCTS) ;
  KORD = 2 ;
  DERIV = 1 ;
  BINWD = (ENDPTS[2,1] - ENDPTS[1,1]) / (NBIN - 1) ;

  IF ISHOW /= 0 ;
    "RUNNING SKSHFH.G" ;
  ENDIF ;

  IF AFLAG == 1 ;     /*  USE AUTOMATIC SHIFTS  */
    IF ISHOW /= 0 ;
      "   CALCULATING PILOT ESTS " ;
    ENDIF ;
    VS = NMDFHB(BINCTS,ENDPTS[1,1],ENDPTS[2,1],SHFTS[1,1],DERIV) ;
    DENOM = NMFHB(BINCTS,ENDPTS[1,1],ENDPTS[2,1],SHFTS[2,1],KORD) ;
                       /*  RECALL SHFTS NOW CONTAINS PILOT BANDWIDTHS  */
    IF DENOM /= 0 ;
      VS = VS ./ DENOM ;
    ELSE ;
      "!!!!!     CAREFUL CANNOT DIVIDE BY ZERO, RETURNING 0     !!!!!" ;
      RETP(0) ;
    ENDIF ;
    VS = VS * (1/2) ;      /*  THIS IS INT(X^2 K)/2 */
  ELSE ;
    VS = SHFTS * (1/2) ;    /*  THIS IS INT(X^2 K)/2 */
  ENDIF ;

  IH = 1 ;
  DO WHILE IH <= ROWS(VH) ;
    H = VH[IH,1] ;
    IF ISHOW /= 0 ;
      "   WORKING ON H NUMBER " IH "      H = " H ;
    ENDIF ;

    BCENTS = SEQA(ENDPTS[1,1],BINWD,NBIN) ;
    BCENTS = BCENTS + H^2 .* VS ;
    BINCTS = NMBLBIN(BINCTS,BCENTS,ENDPTS[1,1],ENDPTS[2,1],NBIN) ;

    IF IH == 1 ;
      SFH = NMFHB(BINCTS,ENDPTS[1,1],ENDPTS[2,1],H,KORD) ;
    ELSE ;
      SFH = SFH~NMFHB(BINCTS,ENDPTS[1,1],ENDPTS[2,1],H,KORD) ;
    ENDIF ;

    IH = IH + 1 ;
  ENDO ;


  RETP(SFH) ;
ENDP ;
/* ============================ END PROC SKSHFH ======================== */
