/* =========================== START PROC SOL5BAND ======================== */
PROC SOL5BAND(AD,AU1,AU2,AL1,AL2,B) ;
    /*  FOR SOLVING A 5 BANDED SYSTEM OF INVERTIBLE LINEAR EQUATIONS   */
    /*  FOR A 5 BANDED nxn MATRIX OF COEFFICIENTS,  A   */
    /*    AD  IS THE n   VECTOR    ON THE DIAGONAL  */
    /*    AU1 IS THE n-1 VECTOR ABOVE THE DIAGONAL  */
    /*    AU2 IS THE n-2 VECTOR ABOVE THE DIAGONAL  */
    /*    AL1 IS THE n-1 VECTOR BELOW THE DIAGONAL  */
    /*    AL2 IS THE n-2 VECTOR BELOW THE DIAGONAL  */
    /*    B   IS THE n   VECTOR OF CONSTANTS        */

  LOCAL N,X,CD,CU1,CL1,D,I,ISTOP,DEL ;

  N = ROWS(B) ;
  X = ZEROS(N,1) ;

  CD = AD ;
  CU1 = AU1 ;
  CL1 = AL1 ;
  D = B ;

  I = 1 ;
  ISTOP = N-2 ;
  DO WHILE I <= ISTOP ;

      DEL = CL1[I] / CD[I] ;
    CD[I+1] = CD[I+1] - DEL * CU1[I] ;
    CU1[I+1] = CU1[I+1] - DEL * AU2[I] ;
    D[I+1] = D[I+1] - DEL * D[I] ;

      DEL = AL2[I] / CD[I] ;
    CL1[I+1] = CL1[I+1] - DEL * CU1[I] ;
    CD[I+2] = CD[I+2] - DEL * AU2[I] ;
    D[I+2] = D[I+2] - DEL * D[I] ;

    I = I + 1 ;
  ENDO ;

    DEL = CL1[N-1] / CD[N-1] ;
  CD[N] = CD[N] - DEL * CU1[N-1] ;
  D[N] = D[N] - DEL * D[N-1] ;



  X[N] = D[N] / CD[N] ;
  X[N-1] = (D[N-1] - CU1[N-1] * X[N]) / CD[N-1] ;

  I = 2 ;
  ISTOP = N-1 ;
  DO WHILE I <= ISTOP ;

    X[N-I] = (D[N-I] - AU2[N-I] * X[N-I+2] - CU1[N-I] * X[N-I+1]) / CD[N-I] ;

    I = I + 1 ;
  ENDO ;



  RETP(X) ;
ENDP ;
/* ============================ END PROC SOL5BAND ======================== */
