/* =========================== START PROC SS2RAW ======================== */
PROC SS2RAW(V,FRAC) ;
    /*  THIS FIND THE SMALLEST SMOOTHED K - SPACING  */
    /*  OF ENTRIES IN A COLUMN VECTOR V  */
    /*  FRAC IS THE FRACTION OF THE NUMBER OF  */
    /*  OBSERVATIONS IN THE TOTAL WINDOW  */
    /*  SMOOTHING IS DONE OVER HALF THE TOTAL NUMBER ON EACH SIDE  */

  LOCAL NOBS,K,SV,VKG,IKG,KG ;

  NOBS = ROWS(V) ;
  K = ROUND(FRAC * NOBS / 2) ;    /* NUMBER OF INDICES IN EACH SMOOTH */

  SV = SORTC(V,1) ;

            /*  GET THE FIRST SMOOTHED GAP  */
  VKG = MEANC(SV[(K+1):(2*K),1]) - MEANC(SV[1:K,1]) ;
  IKG = 2 ;
            /*  NOW LOOP THROUGH AND GET REST BY UPDATING  */
  DO UNTIL IKG+2*K-1 > NOBS ;
    KG = SV[IKG-1,1] - 2 * SV[IKG+K-1,1] + SV[IKG+2*K-1,1] ;
    KG = KG / K ;
    KG = VKG[IKG-1,1] + KG ;    /*  UPDATE DONE HERE  */
    VKG = VKG|KG ;
    IKG = IKG + 1 ;
  ENDO ;

  RETP(MINC(VKG)) ;
ENDP ;
/* ============================ END PROC SS2RAW ======================== */
