/* =========================== START PROC SS3 ======================== */
PROC SS3(SDATA,FRAC) ;
    /*  THIS GIVES A SCALE ESTIMATE  */
    /*  BASED ON THE SMALLEST RAW K - SPACING  */
    /*  OF ENTRIES IN THE VECTOR DATA  */
    /*  !!!   ASSUMED TO BE sorted     !!!      */
    /*  FRAC IS THE FRACTIION OF DATA IN EACH WINDOW  */

  LOCAL NOBS,K,SKG,EKG ;

  NOBS = ROWS(SDATA) ;

             /*  GET RAW MINIMUM SAMPLE K-GAP  */
  K = ROUND(FRAC * (NOBS - 1)) ;       /* NUMBER OF INDICES ACROSS THE GAP */
  SKG = SDATA[(K+1):NOBS,1] - SDATA[1:(NOBS-K),1] ;
  SKG = MINC(SKG) ;

             /*  APPROXIMATE N(0,1) MINIMUM KGAP  */
  EKG = 2 * PHIINV((1 + FRAC) / 2) ;
  EKG = EKG  -  4^(-.875) * (NOBS / 25)^(-2/3) ;

  RETP(SKG/EKG) ;
ENDP ;
/* ============================ END PROC SS3 ======================== */
