/* =========================== START PROC SS3RAW ======================== */
PROC SS3RAW(V,FRAC) ;
    /*  THIS FIND THE SMALLEST RAW K - SPACING  */
    /*  OF ENTRIES IN A COLUMN VECTOR V  */
    /*  FRAC IS THE FRACTION OF THE NUMBER OF  */
    /*  OBSERVATIONS IN THE TOTAL WINDOW  */
    /*  SMOOTHING IS DONE OVER HALF THE TOTAL NUMBER ON EACH SIDE  */

  LOCAL NOBS,K,SV,VKG ;

  NOBS = ROWS(V) ;
  K = ROUND(FRAC * NOBS) ;    /* NUMBER OF INDICES ACROSS THE GAP */

  SV = SORTC(V,1) ;

            /*  GET THE K-GAPS  */
  VKG = SV[(K+1):NOBS,1] - SV[1:(NOBS-K),1] ;

  RETP(MINC(VKG)) ;
ENDP ;
/* ============================ END PROC SS3RAW ======================== */
